/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.clouddirectory.model.ConsistencyLevel;
import software.amazon.awssdk.services.clouddirectory.model.ObjectReference;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetObjectInformationRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, GetObjectInformationRequest> {
    private final String directoryArn;
    private final ObjectReference objectReference;
    private final String consistencyLevel;

    private GetObjectInformationRequest(BuilderImpl builder) {
        this.directoryArn = builder.directoryArn;
        this.objectReference = builder.objectReference;
        this.consistencyLevel = builder.consistencyLevel;
    }

    public String directoryArn() {
        return this.directoryArn;
    }

    public ObjectReference objectReference() {
        return this.objectReference;
    }

    public String consistencyLevel() {
        return this.consistencyLevel;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.directoryArn() == null ? 0 : this.directoryArn().hashCode());
        hashCode = 31 * hashCode + (this.objectReference() == null ? 0 : this.objectReference().hashCode());
        hashCode = 31 * hashCode + (this.consistencyLevel() == null ? 0 : this.consistencyLevel().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetObjectInformationRequest)) {
            return false;
        }
        GetObjectInformationRequest other = (GetObjectInformationRequest)((Object)obj);
        if (other.directoryArn() == null ^ this.directoryArn() == null) {
            return false;
        }
        if (other.directoryArn() != null && !other.directoryArn().equals(this.directoryArn())) {
            return false;
        }
        if (other.objectReference() == null ^ this.objectReference() == null) {
            return false;
        }
        if (other.objectReference() != null && !other.objectReference().equals(this.objectReference())) {
            return false;
        }
        if (other.consistencyLevel() == null ^ this.consistencyLevel() == null) {
            return false;
        }
        return other.consistencyLevel() == null || other.consistencyLevel().equals(this.consistencyLevel());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.directoryArn() != null) {
            sb.append("DirectoryArn: ").append(this.directoryArn()).append(",");
        }
        if (this.objectReference() != null) {
            sb.append("ObjectReference: ").append(this.objectReference()).append(",");
        }
        if (this.consistencyLevel() != null) {
            sb.append("ConsistencyLevel: ").append(this.consistencyLevel()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String directoryArn;
        private ObjectReference objectReference;
        private String consistencyLevel;

        private BuilderImpl() {
        }

        private BuilderImpl(GetObjectInformationRequest model) {
            this.setDirectoryArn(model.directoryArn);
            this.setObjectReference(model.objectReference);
            this.setConsistencyLevel(model.consistencyLevel);
        }

        public final String getDirectoryArn() {
            return this.directoryArn;
        }

        @Override
        public final Builder directoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
            return this;
        }

        public final void setDirectoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
        }

        public final ObjectReference getObjectReference() {
            return this.objectReference;
        }

        @Override
        public final Builder objectReference(ObjectReference objectReference) {
            this.objectReference = objectReference;
            return this;
        }

        public final void setObjectReference(ObjectReference objectReference) {
            this.objectReference = objectReference;
        }

        public final String getConsistencyLevel() {
            return this.consistencyLevel;
        }

        @Override
        public final Builder consistencyLevel(String consistencyLevel) {
            this.consistencyLevel = consistencyLevel;
            return this;
        }

        @Override
        public final Builder consistencyLevel(ConsistencyLevel consistencyLevel) {
            this.consistencyLevel(consistencyLevel.toString());
            return this;
        }

        public final void setConsistencyLevel(String consistencyLevel) {
            this.consistencyLevel = consistencyLevel;
        }

        public GetObjectInformationRequest build() {
            return new GetObjectInformationRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetObjectInformationRequest> {
        public Builder directoryArn(String var1);

        public Builder objectReference(ObjectReference var1);

        public Builder consistencyLevel(String var1);

        public Builder consistencyLevel(ConsistencyLevel var1);
    }
}

