/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.clouddirectory.model.AttributeKeyAndValue;
import software.amazon.awssdk.services.clouddirectory.model.AttributeKeyAndValueListCopier;
import software.amazon.awssdk.services.clouddirectory.model.ObjectReference;
import software.amazon.awssdk.services.clouddirectory.model.SchemaFacet;
import software.amazon.awssdk.services.clouddirectory.model.SchemaFacetListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateObjectRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateObjectRequest> {
    private final String directoryArn;
    private final List<SchemaFacet> schemaFacets;
    private final List<AttributeKeyAndValue> objectAttributeList;
    private final ObjectReference parentReference;
    private final String linkName;

    private CreateObjectRequest(BuilderImpl builder) {
        this.directoryArn = builder.directoryArn;
        this.schemaFacets = builder.schemaFacets;
        this.objectAttributeList = builder.objectAttributeList;
        this.parentReference = builder.parentReference;
        this.linkName = builder.linkName;
    }

    public String directoryArn() {
        return this.directoryArn;
    }

    public List<SchemaFacet> schemaFacets() {
        return this.schemaFacets;
    }

    public List<AttributeKeyAndValue> objectAttributeList() {
        return this.objectAttributeList;
    }

    public ObjectReference parentReference() {
        return this.parentReference;
    }

    public String linkName() {
        return this.linkName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.directoryArn() == null ? 0 : this.directoryArn().hashCode());
        hashCode = 31 * hashCode + (this.schemaFacets() == null ? 0 : this.schemaFacets().hashCode());
        hashCode = 31 * hashCode + (this.objectAttributeList() == null ? 0 : this.objectAttributeList().hashCode());
        hashCode = 31 * hashCode + (this.parentReference() == null ? 0 : this.parentReference().hashCode());
        hashCode = 31 * hashCode + (this.linkName() == null ? 0 : this.linkName().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateObjectRequest)) {
            return false;
        }
        CreateObjectRequest other = (CreateObjectRequest)((Object)obj);
        if (other.directoryArn() == null ^ this.directoryArn() == null) {
            return false;
        }
        if (other.directoryArn() != null && !other.directoryArn().equals(this.directoryArn())) {
            return false;
        }
        if (other.schemaFacets() == null ^ this.schemaFacets() == null) {
            return false;
        }
        if (other.schemaFacets() != null && !other.schemaFacets().equals(this.schemaFacets())) {
            return false;
        }
        if (other.objectAttributeList() == null ^ this.objectAttributeList() == null) {
            return false;
        }
        if (other.objectAttributeList() != null && !other.objectAttributeList().equals(this.objectAttributeList())) {
            return false;
        }
        if (other.parentReference() == null ^ this.parentReference() == null) {
            return false;
        }
        if (other.parentReference() != null && !other.parentReference().equals(this.parentReference())) {
            return false;
        }
        if (other.linkName() == null ^ this.linkName() == null) {
            return false;
        }
        return other.linkName() == null || other.linkName().equals(this.linkName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.directoryArn() != null) {
            sb.append("DirectoryArn: ").append(this.directoryArn()).append(",");
        }
        if (this.schemaFacets() != null) {
            sb.append("SchemaFacets: ").append(this.schemaFacets()).append(",");
        }
        if (this.objectAttributeList() != null) {
            sb.append("ObjectAttributeList: ").append(this.objectAttributeList()).append(",");
        }
        if (this.parentReference() != null) {
            sb.append("ParentReference: ").append(this.parentReference()).append(",");
        }
        if (this.linkName() != null) {
            sb.append("LinkName: ").append(this.linkName()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String directoryArn;
        private List<SchemaFacet> schemaFacets;
        private List<AttributeKeyAndValue> objectAttributeList;
        private ObjectReference parentReference;
        private String linkName;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateObjectRequest model) {
            this.setDirectoryArn(model.directoryArn);
            this.setSchemaFacets(model.schemaFacets);
            this.setObjectAttributeList(model.objectAttributeList);
            this.setParentReference(model.parentReference);
            this.setLinkName(model.linkName);
        }

        public final String getDirectoryArn() {
            return this.directoryArn;
        }

        @Override
        public final Builder directoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
            return this;
        }

        public final void setDirectoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
        }

        public final Collection<SchemaFacet> getSchemaFacets() {
            return this.schemaFacets;
        }

        @Override
        public final Builder schemaFacets(Collection<SchemaFacet> schemaFacets) {
            this.schemaFacets = SchemaFacetListCopier.copy(schemaFacets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder schemaFacets(SchemaFacet ... schemaFacets) {
            this.schemaFacets(Arrays.asList(schemaFacets));
            return this;
        }

        public final void setSchemaFacets(Collection<SchemaFacet> schemaFacets) {
            this.schemaFacets = SchemaFacetListCopier.copy(schemaFacets);
        }

        public final Collection<AttributeKeyAndValue> getObjectAttributeList() {
            return this.objectAttributeList;
        }

        @Override
        public final Builder objectAttributeList(Collection<AttributeKeyAndValue> objectAttributeList) {
            this.objectAttributeList = AttributeKeyAndValueListCopier.copy(objectAttributeList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder objectAttributeList(AttributeKeyAndValue ... objectAttributeList) {
            this.objectAttributeList(Arrays.asList(objectAttributeList));
            return this;
        }

        public final void setObjectAttributeList(Collection<AttributeKeyAndValue> objectAttributeList) {
            this.objectAttributeList = AttributeKeyAndValueListCopier.copy(objectAttributeList);
        }

        public final ObjectReference getParentReference() {
            return this.parentReference;
        }

        @Override
        public final Builder parentReference(ObjectReference parentReference) {
            this.parentReference = parentReference;
            return this;
        }

        public final void setParentReference(ObjectReference parentReference) {
            this.parentReference = parentReference;
        }

        public final String getLinkName() {
            return this.linkName;
        }

        @Override
        public final Builder linkName(String linkName) {
            this.linkName = linkName;
            return this;
        }

        public final void setLinkName(String linkName) {
            this.linkName = linkName;
        }

        public CreateObjectRequest build() {
            return new CreateObjectRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateObjectRequest> {
        public Builder directoryArn(String var1);

        public Builder schemaFacets(Collection<SchemaFacet> var1);

        public Builder schemaFacets(SchemaFacet ... var1);

        public Builder objectAttributeList(Collection<AttributeKeyAndValue> var1);

        public Builder objectAttributeList(AttributeKeyAndValue ... var1);

        public Builder parentReference(ObjectReference var1);

        public Builder linkName(String var1);
    }
}

