/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.clouddirectory.model.BatchWriteOperation;
import software.amazon.awssdk.services.clouddirectory.model.BatchWriteOperationListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BatchWriteRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, BatchWriteRequest> {
    private final String directoryArn;
    private final List<BatchWriteOperation> operations;

    private BatchWriteRequest(BuilderImpl builder) {
        this.directoryArn = builder.directoryArn;
        this.operations = builder.operations;
    }

    public String directoryArn() {
        return this.directoryArn;
    }

    public List<BatchWriteOperation> operations() {
        return this.operations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.directoryArn() == null ? 0 : this.directoryArn().hashCode());
        hashCode = 31 * hashCode + (this.operations() == null ? 0 : this.operations().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchWriteRequest)) {
            return false;
        }
        BatchWriteRequest other = (BatchWriteRequest)((Object)obj);
        if (other.directoryArn() == null ^ this.directoryArn() == null) {
            return false;
        }
        if (other.directoryArn() != null && !other.directoryArn().equals(this.directoryArn())) {
            return false;
        }
        if (other.operations() == null ^ this.operations() == null) {
            return false;
        }
        return other.operations() == null || other.operations().equals(this.operations());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.directoryArn() != null) {
            sb.append("DirectoryArn: ").append(this.directoryArn()).append(",");
        }
        if (this.operations() != null) {
            sb.append("Operations: ").append(this.operations()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String directoryArn;
        private List<BatchWriteOperation> operations;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchWriteRequest model) {
            this.setDirectoryArn(model.directoryArn);
            this.setOperations(model.operations);
        }

        public final String getDirectoryArn() {
            return this.directoryArn;
        }

        @Override
        public final Builder directoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
            return this;
        }

        public final void setDirectoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
        }

        public final Collection<BatchWriteOperation> getOperations() {
            return this.operations;
        }

        @Override
        public final Builder operations(Collection<BatchWriteOperation> operations) {
            this.operations = BatchWriteOperationListCopier.copy(operations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operations(BatchWriteOperation ... operations) {
            this.operations(Arrays.asList(operations));
            return this;
        }

        public final void setOperations(Collection<BatchWriteOperation> operations) {
            this.operations = BatchWriteOperationListCopier.copy(operations);
        }

        public BatchWriteRequest build() {
            return new BatchWriteRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BatchWriteRequest> {
        public Builder directoryArn(String var1);

        public Builder operations(Collection<BatchWriteOperation> var1);

        public Builder operations(BatchWriteOperation ... var1);
    }
}

