/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.clouddirectory.model.ObjectReference;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AttachPolicyRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, AttachPolicyRequest> {
    private final String directoryArn;
    private final ObjectReference policyReference;
    private final ObjectReference objectReference;

    private AttachPolicyRequest(BuilderImpl builder) {
        this.directoryArn = builder.directoryArn;
        this.policyReference = builder.policyReference;
        this.objectReference = builder.objectReference;
    }

    public String directoryArn() {
        return this.directoryArn;
    }

    public ObjectReference policyReference() {
        return this.policyReference;
    }

    public ObjectReference objectReference() {
        return this.objectReference;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.directoryArn() == null ? 0 : this.directoryArn().hashCode());
        hashCode = 31 * hashCode + (this.policyReference() == null ? 0 : this.policyReference().hashCode());
        hashCode = 31 * hashCode + (this.objectReference() == null ? 0 : this.objectReference().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttachPolicyRequest)) {
            return false;
        }
        AttachPolicyRequest other = (AttachPolicyRequest)((Object)obj);
        if (other.directoryArn() == null ^ this.directoryArn() == null) {
            return false;
        }
        if (other.directoryArn() != null && !other.directoryArn().equals(this.directoryArn())) {
            return false;
        }
        if (other.policyReference() == null ^ this.policyReference() == null) {
            return false;
        }
        if (other.policyReference() != null && !other.policyReference().equals(this.policyReference())) {
            return false;
        }
        if (other.objectReference() == null ^ this.objectReference() == null) {
            return false;
        }
        return other.objectReference() == null || other.objectReference().equals(this.objectReference());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.directoryArn() != null) {
            sb.append("DirectoryArn: ").append(this.directoryArn()).append(",");
        }
        if (this.policyReference() != null) {
            sb.append("PolicyReference: ").append(this.policyReference()).append(",");
        }
        if (this.objectReference() != null) {
            sb.append("ObjectReference: ").append(this.objectReference()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String directoryArn;
        private ObjectReference policyReference;
        private ObjectReference objectReference;

        private BuilderImpl() {
        }

        private BuilderImpl(AttachPolicyRequest model) {
            this.setDirectoryArn(model.directoryArn);
            this.setPolicyReference(model.policyReference);
            this.setObjectReference(model.objectReference);
        }

        public final String getDirectoryArn() {
            return this.directoryArn;
        }

        @Override
        public final Builder directoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
            return this;
        }

        public final void setDirectoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
        }

        public final ObjectReference getPolicyReference() {
            return this.policyReference;
        }

        @Override
        public final Builder policyReference(ObjectReference policyReference) {
            this.policyReference = policyReference;
            return this;
        }

        public final void setPolicyReference(ObjectReference policyReference) {
            this.policyReference = policyReference;
        }

        public final ObjectReference getObjectReference() {
            return this.objectReference;
        }

        @Override
        public final Builder objectReference(ObjectReference objectReference) {
            this.objectReference = objectReference;
            return this;
        }

        public final void setObjectReference(ObjectReference objectReference) {
            this.objectReference = objectReference;
        }

        public AttachPolicyRequest build() {
            return new AttachPolicyRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AttachPolicyRequest> {
        public Builder directoryArn(String var1);

        public Builder policyReference(ObjectReference var1);

        public Builder objectReference(ObjectReference var1);
    }
}

