/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.clouddirectory.model.AttributeKeyAndValue;
import software.amazon.awssdk.services.clouddirectory.model.AttributeKeyAndValueListCopier;
import software.amazon.awssdk.services.clouddirectory.model.ObjectReference;
import software.amazon.awssdk.services.clouddirectory.model.SchemaFacet;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AddFacetToObjectRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, AddFacetToObjectRequest> {
    private final String directoryArn;
    private final SchemaFacet schemaFacet;
    private final List<AttributeKeyAndValue> objectAttributeList;
    private final ObjectReference objectReference;

    private AddFacetToObjectRequest(BuilderImpl builder) {
        this.directoryArn = builder.directoryArn;
        this.schemaFacet = builder.schemaFacet;
        this.objectAttributeList = builder.objectAttributeList;
        this.objectReference = builder.objectReference;
    }

    public String directoryArn() {
        return this.directoryArn;
    }

    public SchemaFacet schemaFacet() {
        return this.schemaFacet;
    }

    public List<AttributeKeyAndValue> objectAttributeList() {
        return this.objectAttributeList;
    }

    public ObjectReference objectReference() {
        return this.objectReference;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.directoryArn() == null ? 0 : this.directoryArn().hashCode());
        hashCode = 31 * hashCode + (this.schemaFacet() == null ? 0 : this.schemaFacet().hashCode());
        hashCode = 31 * hashCode + (this.objectAttributeList() == null ? 0 : this.objectAttributeList().hashCode());
        hashCode = 31 * hashCode + (this.objectReference() == null ? 0 : this.objectReference().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddFacetToObjectRequest)) {
            return false;
        }
        AddFacetToObjectRequest other = (AddFacetToObjectRequest)((Object)obj);
        if (other.directoryArn() == null ^ this.directoryArn() == null) {
            return false;
        }
        if (other.directoryArn() != null && !other.directoryArn().equals(this.directoryArn())) {
            return false;
        }
        if (other.schemaFacet() == null ^ this.schemaFacet() == null) {
            return false;
        }
        if (other.schemaFacet() != null && !other.schemaFacet().equals(this.schemaFacet())) {
            return false;
        }
        if (other.objectAttributeList() == null ^ this.objectAttributeList() == null) {
            return false;
        }
        if (other.objectAttributeList() != null && !other.objectAttributeList().equals(this.objectAttributeList())) {
            return false;
        }
        if (other.objectReference() == null ^ this.objectReference() == null) {
            return false;
        }
        return other.objectReference() == null || other.objectReference().equals(this.objectReference());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.directoryArn() != null) {
            sb.append("DirectoryArn: ").append(this.directoryArn()).append(",");
        }
        if (this.schemaFacet() != null) {
            sb.append("SchemaFacet: ").append(this.schemaFacet()).append(",");
        }
        if (this.objectAttributeList() != null) {
            sb.append("ObjectAttributeList: ").append(this.objectAttributeList()).append(",");
        }
        if (this.objectReference() != null) {
            sb.append("ObjectReference: ").append(this.objectReference()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String directoryArn;
        private SchemaFacet schemaFacet;
        private List<AttributeKeyAndValue> objectAttributeList;
        private ObjectReference objectReference;

        private BuilderImpl() {
        }

        private BuilderImpl(AddFacetToObjectRequest model) {
            this.setDirectoryArn(model.directoryArn);
            this.setSchemaFacet(model.schemaFacet);
            this.setObjectAttributeList(model.objectAttributeList);
            this.setObjectReference(model.objectReference);
        }

        public final String getDirectoryArn() {
            return this.directoryArn;
        }

        @Override
        public final Builder directoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
            return this;
        }

        public final void setDirectoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
        }

        public final SchemaFacet getSchemaFacet() {
            return this.schemaFacet;
        }

        @Override
        public final Builder schemaFacet(SchemaFacet schemaFacet) {
            this.schemaFacet = schemaFacet;
            return this;
        }

        public final void setSchemaFacet(SchemaFacet schemaFacet) {
            this.schemaFacet = schemaFacet;
        }

        public final Collection<AttributeKeyAndValue> getObjectAttributeList() {
            return this.objectAttributeList;
        }

        @Override
        public final Builder objectAttributeList(Collection<AttributeKeyAndValue> objectAttributeList) {
            this.objectAttributeList = AttributeKeyAndValueListCopier.copy(objectAttributeList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder objectAttributeList(AttributeKeyAndValue ... objectAttributeList) {
            this.objectAttributeList(Arrays.asList(objectAttributeList));
            return this;
        }

        public final void setObjectAttributeList(Collection<AttributeKeyAndValue> objectAttributeList) {
            this.objectAttributeList = AttributeKeyAndValueListCopier.copy(objectAttributeList);
        }

        public final ObjectReference getObjectReference() {
            return this.objectReference;
        }

        @Override
        public final Builder objectReference(ObjectReference objectReference) {
            this.objectReference = objectReference;
            return this;
        }

        public final void setObjectReference(ObjectReference objectReference) {
            this.objectReference = objectReference;
        }

        public AddFacetToObjectRequest build() {
            return new AddFacetToObjectRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AddFacetToObjectRequest> {
        public Builder directoryArn(String var1);

        public Builder schemaFacet(SchemaFacet var1);

        public Builder objectAttributeList(Collection<AttributeKeyAndValue> var1);

        public Builder objectAttributeList(AttributeKeyAndValue ... var1);

        public Builder objectReference(ObjectReference var1);
    }
}

