/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.transform;

import java.util.List;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.clouddirectory.model.ListIndexRequest;

@SdkInternalApi
public class ListIndexRequestModelMarshaller {
    private static final MarshallingInfo<String> DIRECTORYARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.HEADER).marshallLocationName("x-amz-data-partition").build();
    private static final MarshallingInfo<List> RANGESONINDEXEDVALUES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RangesOnIndexedValues").build();
    private static final MarshallingInfo<StructuredPojo> INDEXREFERENCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IndexReference").build();
    private static final MarshallingInfo<Integer> MAXRESULTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaxResults").build();
    private static final MarshallingInfo<String> NEXTTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NextToken").build();
    private static final MarshallingInfo<String> CONSISTENCYLEVEL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.HEADER).marshallLocationName("x-amz-consistency-level").build();
    private static final ListIndexRequestModelMarshaller instance = new ListIndexRequestModelMarshaller();

    public static ListIndexRequestModelMarshaller getInstance() {
        return instance;
    }

    public void marshall(ListIndexRequest listIndexRequest, ProtocolMarshaller protocolMarshaller) {
        if (listIndexRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)listIndexRequest.directoryArn(), DIRECTORYARN_BINDING);
            protocolMarshaller.marshall(listIndexRequest.rangesOnIndexedValues(), RANGESONINDEXEDVALUES_BINDING);
            protocolMarshaller.marshall((Object)listIndexRequest.indexReference(), INDEXREFERENCE_BINDING);
            protocolMarshaller.marshall((Object)listIndexRequest.maxResults(), MAXRESULTS_BINDING);
            protocolMarshaller.marshall((Object)listIndexRequest.nextToken(), NEXTTOKEN_BINDING);
            protocolMarshaller.marshall((Object)listIndexRequest.consistencyLevel(), CONSISTENCYLEVEL_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

