/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.clouddirectory.model.AttributeKey;
import software.amazon.awssdk.services.clouddirectory.model.ObjectAttributeAction;
import software.amazon.awssdk.services.clouddirectory.transform.ObjectAttributeUpdateMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ObjectAttributeUpdate
implements StructuredPojo,
ToCopyableBuilder<Builder, ObjectAttributeUpdate> {
    private final AttributeKey objectAttributeKey;
    private final ObjectAttributeAction objectAttributeAction;

    private ObjectAttributeUpdate(BuilderImpl builder) {
        this.objectAttributeKey = builder.objectAttributeKey;
        this.objectAttributeAction = builder.objectAttributeAction;
    }

    public AttributeKey objectAttributeKey() {
        return this.objectAttributeKey;
    }

    public ObjectAttributeAction objectAttributeAction() {
        return this.objectAttributeAction;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.objectAttributeKey() == null ? 0 : this.objectAttributeKey().hashCode());
        hashCode = 31 * hashCode + (this.objectAttributeAction() == null ? 0 : this.objectAttributeAction().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ObjectAttributeUpdate)) {
            return false;
        }
        ObjectAttributeUpdate other = (ObjectAttributeUpdate)obj;
        if (other.objectAttributeKey() == null ^ this.objectAttributeKey() == null) {
            return false;
        }
        if (other.objectAttributeKey() != null && !other.objectAttributeKey().equals(this.objectAttributeKey())) {
            return false;
        }
        if (other.objectAttributeAction() == null ^ this.objectAttributeAction() == null) {
            return false;
        }
        return other.objectAttributeAction() == null || other.objectAttributeAction().equals(this.objectAttributeAction());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.objectAttributeKey() != null) {
            sb.append("ObjectAttributeKey: ").append(this.objectAttributeKey()).append(",");
        }
        if (this.objectAttributeAction() != null) {
            sb.append("ObjectAttributeAction: ").append(this.objectAttributeAction()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ObjectAttributeUpdateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private AttributeKey objectAttributeKey;
        private ObjectAttributeAction objectAttributeAction;

        private BuilderImpl() {
        }

        private BuilderImpl(ObjectAttributeUpdate model) {
            this.setObjectAttributeKey(model.objectAttributeKey);
            this.setObjectAttributeAction(model.objectAttributeAction);
        }

        public final AttributeKey getObjectAttributeKey() {
            return this.objectAttributeKey;
        }

        @Override
        public final Builder objectAttributeKey(AttributeKey objectAttributeKey) {
            this.objectAttributeKey = objectAttributeKey;
            return this;
        }

        public final void setObjectAttributeKey(AttributeKey objectAttributeKey) {
            this.objectAttributeKey = objectAttributeKey;
        }

        public final ObjectAttributeAction getObjectAttributeAction() {
            return this.objectAttributeAction;
        }

        @Override
        public final Builder objectAttributeAction(ObjectAttributeAction objectAttributeAction) {
            this.objectAttributeAction = objectAttributeAction;
            return this;
        }

        public final void setObjectAttributeAction(ObjectAttributeAction objectAttributeAction) {
            this.objectAttributeAction = objectAttributeAction;
        }

        public ObjectAttributeUpdate build() {
            return new ObjectAttributeUpdate(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ObjectAttributeUpdate> {
        public Builder objectAttributeKey(AttributeKey var1);

        public Builder objectAttributeAction(ObjectAttributeAction var1);
    }
}

