/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.clouddirectory.model.FacetAttribute;
import software.amazon.awssdk.services.clouddirectory.model.FacetAttributeListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListFacetAttributesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListFacetAttributesResponse> {
    private final List<FacetAttribute> attributes;
    private final String nextToken;

    private ListFacetAttributesResponse(BuilderImpl builder) {
        this.attributes = builder.attributes;
        this.nextToken = builder.nextToken;
    }

    public List<FacetAttribute> attributes() {
        return this.attributes;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.attributes() == null ? 0 : this.attributes().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFacetAttributesResponse)) {
            return false;
        }
        ListFacetAttributesResponse other = (ListFacetAttributesResponse)((Object)obj);
        if (other.attributes() == null ^ this.attributes() == null) {
            return false;
        }
        if (other.attributes() != null && !other.attributes().equals(this.attributes())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.attributes() != null) {
            sb.append("Attributes: ").append(this.attributes()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<FacetAttribute> attributes;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFacetAttributesResponse model) {
            this.setAttributes(model.attributes);
            this.setNextToken(model.nextToken);
        }

        public final Collection<FacetAttribute> getAttributes() {
            return this.attributes;
        }

        @Override
        public final Builder attributes(Collection<FacetAttribute> attributes) {
            this.attributes = FacetAttributeListCopier.copy(attributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(FacetAttribute ... attributes) {
            this.attributes(Arrays.asList(attributes));
            return this;
        }

        public final void setAttributes(Collection<FacetAttribute> attributes) {
            this.attributes = FacetAttributeListCopier.copy(attributes);
        }

        @SafeVarargs
        public final void setAttributes(FacetAttribute ... attributes) {
            this.attributes(Arrays.asList(attributes));
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListFacetAttributesResponse build() {
            return new ListFacetAttributesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListFacetAttributesResponse> {
        public Builder attributes(Collection<FacetAttribute> var1);

        public Builder attributes(FacetAttribute ... var1);

        public Builder nextToken(String var1);
    }
}

