/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.clouddirectory.model.FacetAttributeDefinition;
import software.amazon.awssdk.services.clouddirectory.model.FacetAttributeReference;
import software.amazon.awssdk.services.clouddirectory.model.RequiredAttributeBehavior;
import software.amazon.awssdk.services.clouddirectory.transform.FacetAttributeMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class FacetAttribute
implements StructuredPojo,
ToCopyableBuilder<Builder, FacetAttribute> {
    private final String name;
    private final FacetAttributeDefinition attributeDefinition;
    private final FacetAttributeReference attributeReference;
    private final String requiredBehavior;

    private FacetAttribute(BuilderImpl builder) {
        this.name = builder.name;
        this.attributeDefinition = builder.attributeDefinition;
        this.attributeReference = builder.attributeReference;
        this.requiredBehavior = builder.requiredBehavior;
    }

    public String name() {
        return this.name;
    }

    public FacetAttributeDefinition attributeDefinition() {
        return this.attributeDefinition;
    }

    public FacetAttributeReference attributeReference() {
        return this.attributeReference;
    }

    public String requiredBehavior() {
        return this.requiredBehavior;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.attributeDefinition() == null ? 0 : this.attributeDefinition().hashCode());
        hashCode = 31 * hashCode + (this.attributeReference() == null ? 0 : this.attributeReference().hashCode());
        hashCode = 31 * hashCode + (this.requiredBehavior() == null ? 0 : this.requiredBehavior().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FacetAttribute)) {
            return false;
        }
        FacetAttribute other = (FacetAttribute)obj;
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.attributeDefinition() == null ^ this.attributeDefinition() == null) {
            return false;
        }
        if (other.attributeDefinition() != null && !other.attributeDefinition().equals(this.attributeDefinition())) {
            return false;
        }
        if (other.attributeReference() == null ^ this.attributeReference() == null) {
            return false;
        }
        if (other.attributeReference() != null && !other.attributeReference().equals(this.attributeReference())) {
            return false;
        }
        if (other.requiredBehavior() == null ^ this.requiredBehavior() == null) {
            return false;
        }
        return other.requiredBehavior() == null || other.requiredBehavior().equals(this.requiredBehavior());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.attributeDefinition() != null) {
            sb.append("AttributeDefinition: ").append(this.attributeDefinition()).append(",");
        }
        if (this.attributeReference() != null) {
            sb.append("AttributeReference: ").append(this.attributeReference()).append(",");
        }
        if (this.requiredBehavior() != null) {
            sb.append("RequiredBehavior: ").append(this.requiredBehavior()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FacetAttributeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String name;
        private FacetAttributeDefinition attributeDefinition;
        private FacetAttributeReference attributeReference;
        private String requiredBehavior;

        private BuilderImpl() {
        }

        private BuilderImpl(FacetAttribute model) {
            this.setName(model.name);
            this.setAttributeDefinition(model.attributeDefinition);
            this.setAttributeReference(model.attributeReference);
            this.setRequiredBehavior(model.requiredBehavior);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final FacetAttributeDefinition getAttributeDefinition() {
            return this.attributeDefinition;
        }

        @Override
        public final Builder attributeDefinition(FacetAttributeDefinition attributeDefinition) {
            this.attributeDefinition = attributeDefinition;
            return this;
        }

        public final void setAttributeDefinition(FacetAttributeDefinition attributeDefinition) {
            this.attributeDefinition = attributeDefinition;
        }

        public final FacetAttributeReference getAttributeReference() {
            return this.attributeReference;
        }

        @Override
        public final Builder attributeReference(FacetAttributeReference attributeReference) {
            this.attributeReference = attributeReference;
            return this;
        }

        public final void setAttributeReference(FacetAttributeReference attributeReference) {
            this.attributeReference = attributeReference;
        }

        public final String getRequiredBehavior() {
            return this.requiredBehavior;
        }

        @Override
        public final Builder requiredBehavior(String requiredBehavior) {
            this.requiredBehavior = requiredBehavior;
            return this;
        }

        @Override
        public final Builder requiredBehavior(RequiredAttributeBehavior requiredBehavior) {
            this.requiredBehavior(requiredBehavior.toString());
            return this;
        }

        public final void setRequiredBehavior(String requiredBehavior) {
            this.requiredBehavior = requiredBehavior;
        }

        public final void setRequiredBehavior(RequiredAttributeBehavior requiredBehavior) {
            this.requiredBehavior(requiredBehavior.toString());
        }

        public FacetAttribute build() {
            return new FacetAttribute(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, FacetAttribute> {
        public Builder name(String var1);

        public Builder attributeDefinition(FacetAttributeDefinition var1);

        public Builder attributeReference(FacetAttributeReference var1);

        public Builder requiredBehavior(String var1);

        public Builder requiredBehavior(RequiredAttributeBehavior var1);
    }
}

