/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.clouddirectory.CloudDirectoryAsyncClient;
import software.amazon.awssdk.services.clouddirectory.model.ListDevelopmentSchemaArnsRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListDevelopmentSchemaArnsResponse;

public class ListDevelopmentSchemaArnsPublisher
implements SdkPublisher<ListDevelopmentSchemaArnsResponse> {
    private final CloudDirectoryAsyncClient client;
    private final ListDevelopmentSchemaArnsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDevelopmentSchemaArnsPublisher(CloudDirectoryAsyncClient client, ListDevelopmentSchemaArnsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDevelopmentSchemaArnsPublisher(CloudDirectoryAsyncClient client, ListDevelopmentSchemaArnsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDevelopmentSchemaArnsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDevelopmentSchemaArnsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private final ListDevelopmentSchemaArnsPublisher resume(ListDevelopmentSchemaArnsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListDevelopmentSchemaArnsPublisher(this.client, (ListDevelopmentSchemaArnsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListDevelopmentSchemaArnsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListDevelopmentSchemaArnsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListDevelopmentSchemaArnsResponseFetcher
    implements AsyncPageFetcher<ListDevelopmentSchemaArnsResponse> {
        private ListDevelopmentSchemaArnsResponseFetcher() {
        }

        public boolean hasNextPage(ListDevelopmentSchemaArnsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDevelopmentSchemaArnsResponse> nextPage(ListDevelopmentSchemaArnsResponse previousPage) {
            if (previousPage == null) {
                return ListDevelopmentSchemaArnsPublisher.this.client.listDevelopmentSchemaArns(ListDevelopmentSchemaArnsPublisher.this.firstRequest);
            }
            return ListDevelopmentSchemaArnsPublisher.this.client.listDevelopmentSchemaArns((ListDevelopmentSchemaArnsRequest)((Object)ListDevelopmentSchemaArnsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

