/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.clouddirectory.model.TypedAttributeValueRange;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class TypedAttributeValueRangeMarshaller {
    private static final MarshallingInfo<String> STARTMODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StartMode").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> STARTVALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StartValue").isBinary(false).build();
    private static final MarshallingInfo<String> ENDMODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EndMode").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> ENDVALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EndValue").isBinary(false).build();
    private static final TypedAttributeValueRangeMarshaller INSTANCE = new TypedAttributeValueRangeMarshaller();

    private TypedAttributeValueRangeMarshaller() {
    }

    public static TypedAttributeValueRangeMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(TypedAttributeValueRange typedAttributeValueRange, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)typedAttributeValueRange, (String)"typedAttributeValueRange");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)typedAttributeValueRange.startModeAsString(), STARTMODE_BINDING);
            protocolMarshaller.marshall((Object)typedAttributeValueRange.startValue(), STARTVALUE_BINDING);
            protocolMarshaller.marshall((Object)typedAttributeValueRange.endModeAsString(), ENDMODE_BINDING);
            protocolMarshaller.marshall((Object)typedAttributeValueRange.endValue(), ENDVALUE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

