/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.clouddirectory.model.PolicyAttachment;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class PolicyAttachmentMarshaller {
    private static final MarshallingInfo<String> POLICYID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PolicyId").isBinary(false).build();
    private static final MarshallingInfo<String> OBJECTIDENTIFIER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ObjectIdentifier").isBinary(false).build();
    private static final MarshallingInfo<String> POLICYTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PolicyType").isBinary(false).build();
    private static final PolicyAttachmentMarshaller INSTANCE = new PolicyAttachmentMarshaller();

    private PolicyAttachmentMarshaller() {
    }

    public static PolicyAttachmentMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(PolicyAttachment policyAttachment, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)policyAttachment, (String)"policyAttachment");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)policyAttachment.policyId(), POLICYID_BINDING);
            protocolMarshaller.marshall((Object)policyAttachment.objectIdentifier(), OBJECTIDENTIFIER_BINDING);
            protocolMarshaller.marshall((Object)policyAttachment.policyType(), POLICYTYPE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

