/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.clouddirectory.model.LinkAttributeUpdate;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class LinkAttributeUpdateMarshaller {
    private static final MarshallingInfo<StructuredPojo> ATTRIBUTEKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AttributeKey").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> ATTRIBUTEACTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AttributeAction").isBinary(false).build();
    private static final LinkAttributeUpdateMarshaller INSTANCE = new LinkAttributeUpdateMarshaller();

    private LinkAttributeUpdateMarshaller() {
    }

    public static LinkAttributeUpdateMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(LinkAttributeUpdate linkAttributeUpdate, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)linkAttributeUpdate, (String)"linkAttributeUpdate");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)linkAttributeUpdate.attributeKey(), ATTRIBUTEKEY_BINDING);
            protocolMarshaller.marshall((Object)linkAttributeUpdate.attributeAction(), ATTRIBUTEACTION_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

