/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.clouddirectory.model.CreateIndexRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CreateIndexRequestModelMarshaller {
    private static final MarshallingInfo<String> DIRECTORYARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.HEADER).marshallLocationName("x-amz-data-partition").isBinary(false).build();
    private static final MarshallingInfo<List> ORDEREDINDEXEDATTRIBUTELIST_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OrderedIndexedAttributeList").isBinary(false).build();
    private static final MarshallingInfo<Boolean> ISUNIQUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IsUnique").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> PARENTREFERENCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ParentReference").isBinary(false).build();
    private static final MarshallingInfo<String> LINKNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LinkName").isBinary(false).build();
    private static final CreateIndexRequestModelMarshaller INSTANCE = new CreateIndexRequestModelMarshaller();

    private CreateIndexRequestModelMarshaller() {
    }

    public static CreateIndexRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateIndexRequest createIndexRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)createIndexRequest), (String)"createIndexRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)createIndexRequest.directoryArn(), DIRECTORYARN_BINDING);
            protocolMarshaller.marshall(createIndexRequest.orderedIndexedAttributeList(), ORDEREDINDEXEDATTRIBUTELIST_BINDING);
            protocolMarshaller.marshall((Object)createIndexRequest.isUnique(), ISUNIQUE_BINDING);
            protocolMarshaller.marshall((Object)createIndexRequest.parentReference(), PARENTREFERENCE_BINDING);
            protocolMarshaller.marshall((Object)createIndexRequest.linkName(), LINKNAME_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

