/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.clouddirectory.model.BatchListObjectAttributesResponse;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class BatchListObjectAttributesResponseMarshaller {
    private static final MarshallingInfo<List> ATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Attributes").isBinary(false).build();
    private static final MarshallingInfo<String> NEXTTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NextToken").isBinary(false).build();
    private static final BatchListObjectAttributesResponseMarshaller INSTANCE = new BatchListObjectAttributesResponseMarshaller();

    private BatchListObjectAttributesResponseMarshaller() {
    }

    public static BatchListObjectAttributesResponseMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(BatchListObjectAttributesResponse batchListObjectAttributesResponse, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)batchListObjectAttributesResponse, (String)"batchListObjectAttributesResponse");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(batchListObjectAttributesResponse.attributes(), ATTRIBUTES_BINDING);
            protocolMarshaller.marshall((Object)batchListObjectAttributesResponse.nextToken(), NEXTTOKEN_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

