/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.clouddirectory.model.BatchGetLinkAttributes;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class BatchGetLinkAttributesMarshaller {
    private static final MarshallingInfo<StructuredPojo> TYPEDLINKSPECIFIER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TypedLinkSpecifier").isBinary(false).build();
    private static final MarshallingInfo<List> ATTRIBUTENAMES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AttributeNames").isBinary(false).build();
    private static final BatchGetLinkAttributesMarshaller INSTANCE = new BatchGetLinkAttributesMarshaller();

    private BatchGetLinkAttributesMarshaller() {
    }

    public static BatchGetLinkAttributesMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(BatchGetLinkAttributes batchGetLinkAttributes, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)batchGetLinkAttributes, (String)"batchGetLinkAttributes");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)batchGetLinkAttributes.typedLinkSpecifier(), TYPEDLINKSPECIFIER_BINDING);
            protocolMarshaller.marshall(batchGetLinkAttributes.attributeNames(), ATTRIBUTENAMES_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

