/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.clouddirectory.model.BatchDetachFromIndex;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class BatchDetachFromIndexMarshaller {
    private static final MarshallingInfo<StructuredPojo> INDEXREFERENCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IndexReference").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> TARGETREFERENCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TargetReference").isBinary(false).build();
    private static final BatchDetachFromIndexMarshaller INSTANCE = new BatchDetachFromIndexMarshaller();

    private BatchDetachFromIndexMarshaller() {
    }

    public static BatchDetachFromIndexMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(BatchDetachFromIndex batchDetachFromIndex, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)batchDetachFromIndex, (String)"batchDetachFromIndex");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)batchDetachFromIndex.indexReference(), INDEXREFERENCE_BINDING);
            protocolMarshaller.marshall((Object)batchDetachFromIndex.targetReference(), TARGETREFERENCE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

