/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.clouddirectory.model.AttachToIndexRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class AttachToIndexRequestModelMarshaller {
    private static final MarshallingInfo<String> DIRECTORYARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.HEADER).marshallLocationName("x-amz-data-partition").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> INDEXREFERENCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IndexReference").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> TARGETREFERENCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TargetReference").isBinary(false).build();
    private static final AttachToIndexRequestModelMarshaller INSTANCE = new AttachToIndexRequestModelMarshaller();

    private AttachToIndexRequestModelMarshaller() {
    }

    public static AttachToIndexRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(AttachToIndexRequest attachToIndexRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)attachToIndexRequest), (String)"attachToIndexRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)attachToIndexRequest.directoryArn(), DIRECTORYARN_BINDING);
            protocolMarshaller.marshall((Object)attachToIndexRequest.indexReference(), INDEXREFERENCE_BINDING);
            protocolMarshaller.marshall((Object)attachToIndexRequest.targetReference(), TARGETREFERENCE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

