/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.clouddirectory.CloudDirectoryAsyncClient;
import software.amazon.awssdk.services.clouddirectory.model.ListPolicyAttachmentsRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListPolicyAttachmentsResponse;

public class ListPolicyAttachmentsPublisher
implements SdkPublisher<ListPolicyAttachmentsResponse> {
    private final CloudDirectoryAsyncClient client;
    private final ListPolicyAttachmentsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPolicyAttachmentsPublisher(CloudDirectoryAsyncClient client, ListPolicyAttachmentsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPolicyAttachmentsPublisher(CloudDirectoryAsyncClient client, ListPolicyAttachmentsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPolicyAttachmentsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPolicyAttachmentsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private final ListPolicyAttachmentsPublisher resume(ListPolicyAttachmentsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListPolicyAttachmentsPublisher(this.client, (ListPolicyAttachmentsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListPolicyAttachmentsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListPolicyAttachmentsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListPolicyAttachmentsResponseFetcher
    implements AsyncPageFetcher<ListPolicyAttachmentsResponse> {
        private ListPolicyAttachmentsResponseFetcher() {
        }

        public boolean hasNextPage(ListPolicyAttachmentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListPolicyAttachmentsResponse> nextPage(ListPolicyAttachmentsResponse previousPage) {
            if (previousPage == null) {
                return ListPolicyAttachmentsPublisher.this.client.listPolicyAttachments(ListPolicyAttachmentsPublisher.this.firstRequest);
            }
            return ListPolicyAttachmentsPublisher.this.client.listPolicyAttachments((ListPolicyAttachmentsRequest)((Object)ListPolicyAttachmentsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

