/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.clouddirectory.model.CloudDirectoryRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpgradePublishedSchemaRequest
extends CloudDirectoryRequest
implements ToCopyableBuilder<Builder, UpgradePublishedSchemaRequest> {
    private final String developmentSchemaArn;
    private final String publishedSchemaArn;
    private final String minorVersion;
    private final Boolean dryRun;

    private UpgradePublishedSchemaRequest(BuilderImpl builder) {
        super(builder);
        this.developmentSchemaArn = builder.developmentSchemaArn;
        this.publishedSchemaArn = builder.publishedSchemaArn;
        this.minorVersion = builder.minorVersion;
        this.dryRun = builder.dryRun;
    }

    public String developmentSchemaArn() {
        return this.developmentSchemaArn;
    }

    public String publishedSchemaArn() {
        return this.publishedSchemaArn;
    }

    public String minorVersion() {
        return this.minorVersion;
    }

    public Boolean dryRun() {
        return this.dryRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.developmentSchemaArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.publishedSchemaArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.minorVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpgradePublishedSchemaRequest)) {
            return false;
        }
        UpgradePublishedSchemaRequest other = (UpgradePublishedSchemaRequest)((Object)obj);
        return Objects.equals(this.developmentSchemaArn(), other.developmentSchemaArn()) && Objects.equals(this.publishedSchemaArn(), other.publishedSchemaArn()) && Objects.equals(this.minorVersion(), other.minorVersion()) && Objects.equals(this.dryRun(), other.dryRun());
    }

    public String toString() {
        return ToString.builder((String)"UpgradePublishedSchemaRequest").add("DevelopmentSchemaArn", (Object)this.developmentSchemaArn()).add("PublishedSchemaArn", (Object)this.publishedSchemaArn()).add("MinorVersion", (Object)this.minorVersion()).add("DryRun", (Object)this.dryRun()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DevelopmentSchemaArn": {
                return Optional.ofNullable(clazz.cast(this.developmentSchemaArn()));
            }
            case "PublishedSchemaArn": {
                return Optional.ofNullable(clazz.cast(this.publishedSchemaArn()));
            }
            case "MinorVersion": {
                return Optional.ofNullable(clazz.cast(this.minorVersion()));
            }
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudDirectoryRequest.BuilderImpl
    implements Builder {
        private String developmentSchemaArn;
        private String publishedSchemaArn;
        private String minorVersion;
        private Boolean dryRun;

        private BuilderImpl() {
        }

        private BuilderImpl(UpgradePublishedSchemaRequest model) {
            super(model);
            this.developmentSchemaArn(model.developmentSchemaArn);
            this.publishedSchemaArn(model.publishedSchemaArn);
            this.minorVersion(model.minorVersion);
            this.dryRun(model.dryRun);
        }

        public final String getDevelopmentSchemaArn() {
            return this.developmentSchemaArn;
        }

        @Override
        public final Builder developmentSchemaArn(String developmentSchemaArn) {
            this.developmentSchemaArn = developmentSchemaArn;
            return this;
        }

        public final void setDevelopmentSchemaArn(String developmentSchemaArn) {
            this.developmentSchemaArn = developmentSchemaArn;
        }

        public final String getPublishedSchemaArn() {
            return this.publishedSchemaArn;
        }

        @Override
        public final Builder publishedSchemaArn(String publishedSchemaArn) {
            this.publishedSchemaArn = publishedSchemaArn;
            return this;
        }

        public final void setPublishedSchemaArn(String publishedSchemaArn) {
            this.publishedSchemaArn = publishedSchemaArn;
        }

        public final String getMinorVersion() {
            return this.minorVersion;
        }

        @Override
        public final Builder minorVersion(String minorVersion) {
            this.minorVersion = minorVersion;
            return this;
        }

        public final void setMinorVersion(String minorVersion) {
            this.minorVersion = minorVersion;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpgradePublishedSchemaRequest build() {
            return new UpgradePublishedSchemaRequest(this);
        }
    }

    public static interface Builder
    extends CloudDirectoryRequest.Builder,
    CopyableBuilder<Builder, UpgradePublishedSchemaRequest> {
        public Builder developmentSchemaArn(String var1);

        public Builder publishedSchemaArn(String var1);

        public Builder minorVersion(String var1);

        public Builder dryRun(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

