/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.adapter.StandardMemberCopier;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.clouddirectory.transform.TypedAttributeValueMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TypedAttributeValue
implements StructuredPojo,
ToCopyableBuilder<Builder, TypedAttributeValue> {
    private final String stringValue;
    private final SdkBytes binaryValue;
    private final Boolean booleanValue;
    private final String numberValue;
    private final Instant datetimeValue;

    private TypedAttributeValue(BuilderImpl builder) {
        this.stringValue = builder.stringValue;
        this.binaryValue = builder.binaryValue;
        this.booleanValue = builder.booleanValue;
        this.numberValue = builder.numberValue;
        this.datetimeValue = builder.datetimeValue;
    }

    public String stringValue() {
        return this.stringValue;
    }

    public SdkBytes binaryValue() {
        return this.binaryValue;
    }

    public Boolean booleanValue() {
        return this.booleanValue;
    }

    public String numberValue() {
        return this.numberValue;
    }

    public Instant datetimeValue() {
        return this.datetimeValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stringValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.binaryValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.booleanValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.datetimeValue());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TypedAttributeValue)) {
            return false;
        }
        TypedAttributeValue other = (TypedAttributeValue)obj;
        return Objects.equals(this.stringValue(), other.stringValue()) && Objects.equals(this.binaryValue(), other.binaryValue()) && Objects.equals(this.booleanValue(), other.booleanValue()) && Objects.equals(this.numberValue(), other.numberValue()) && Objects.equals(this.datetimeValue(), other.datetimeValue());
    }

    public String toString() {
        return ToString.builder((String)"TypedAttributeValue").add("StringValue", (Object)this.stringValue()).add("BinaryValue", (Object)this.binaryValue()).add("BooleanValue", (Object)this.booleanValue()).add("NumberValue", (Object)this.numberValue()).add("DatetimeValue", (Object)this.datetimeValue()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StringValue": {
                return Optional.ofNullable(clazz.cast(this.stringValue()));
            }
            case "BinaryValue": {
                return Optional.ofNullable(clazz.cast(this.binaryValue()));
            }
            case "BooleanValue": {
                return Optional.ofNullable(clazz.cast(this.booleanValue()));
            }
            case "NumberValue": {
                return Optional.ofNullable(clazz.cast(this.numberValue()));
            }
            case "DatetimeValue": {
                return Optional.ofNullable(clazz.cast(this.datetimeValue()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TypedAttributeValueMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String stringValue;
        private SdkBytes binaryValue;
        private Boolean booleanValue;
        private String numberValue;
        private Instant datetimeValue;

        private BuilderImpl() {
        }

        private BuilderImpl(TypedAttributeValue model) {
            this.stringValue(model.stringValue);
            this.binaryValue(model.binaryValue);
            this.booleanValue(model.booleanValue);
            this.numberValue(model.numberValue);
            this.datetimeValue(model.datetimeValue);
        }

        public final String getStringValue() {
            return this.stringValue;
        }

        @Override
        public final Builder stringValue(String stringValue) {
            this.stringValue = stringValue;
            return this;
        }

        public final void setStringValue(String stringValue) {
            this.stringValue = stringValue;
        }

        public final ByteBuffer getBinaryValue() {
            return this.binaryValue == null ? null : this.binaryValue.asByteBuffer();
        }

        @Override
        public final Builder binaryValue(SdkBytes binaryValue) {
            this.binaryValue = StandardMemberCopier.copy((SdkBytes)binaryValue);
            return this;
        }

        public final void setBinaryValue(ByteBuffer binaryValue) {
            this.binaryValue(binaryValue == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)binaryValue));
        }

        public final Boolean getBooleanValue() {
            return this.booleanValue;
        }

        @Override
        public final Builder booleanValue(Boolean booleanValue) {
            this.booleanValue = booleanValue;
            return this;
        }

        public final void setBooleanValue(Boolean booleanValue) {
            this.booleanValue = booleanValue;
        }

        public final String getNumberValue() {
            return this.numberValue;
        }

        @Override
        public final Builder numberValue(String numberValue) {
            this.numberValue = numberValue;
            return this;
        }

        public final void setNumberValue(String numberValue) {
            this.numberValue = numberValue;
        }

        public final Instant getDatetimeValue() {
            return this.datetimeValue;
        }

        @Override
        public final Builder datetimeValue(Instant datetimeValue) {
            this.datetimeValue = datetimeValue;
            return this;
        }

        public final void setDatetimeValue(Instant datetimeValue) {
            this.datetimeValue = datetimeValue;
        }

        public TypedAttributeValue build() {
            return new TypedAttributeValue(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, TypedAttributeValue> {
        public Builder stringValue(String var1);

        public Builder binaryValue(SdkBytes var1);

        public Builder booleanValue(Boolean var1);

        public Builder numberValue(String var1);

        public Builder datetimeValue(Instant var1);
    }
}

