/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.clouddirectory.model.CloudDirectoryRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PublishSchemaRequest
extends CloudDirectoryRequest
implements ToCopyableBuilder<Builder, PublishSchemaRequest> {
    private final String developmentSchemaArn;
    private final String version;
    private final String minorVersion;
    private final String name;

    private PublishSchemaRequest(BuilderImpl builder) {
        super(builder);
        this.developmentSchemaArn = builder.developmentSchemaArn;
        this.version = builder.version;
        this.minorVersion = builder.minorVersion;
        this.name = builder.name;
    }

    public String developmentSchemaArn() {
        return this.developmentSchemaArn;
    }

    public String version() {
        return this.version;
    }

    public String minorVersion() {
        return this.minorVersion;
    }

    public String name() {
        return this.name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.developmentSchemaArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.minorVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PublishSchemaRequest)) {
            return false;
        }
        PublishSchemaRequest other = (PublishSchemaRequest)((Object)obj);
        return Objects.equals(this.developmentSchemaArn(), other.developmentSchemaArn()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.minorVersion(), other.minorVersion()) && Objects.equals(this.name(), other.name());
    }

    public String toString() {
        return ToString.builder((String)"PublishSchemaRequest").add("DevelopmentSchemaArn", (Object)this.developmentSchemaArn()).add("Version", (Object)this.version()).add("MinorVersion", (Object)this.minorVersion()).add("Name", (Object)this.name()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DevelopmentSchemaArn": {
                return Optional.ofNullable(clazz.cast(this.developmentSchemaArn()));
            }
            case "Version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "MinorVersion": {
                return Optional.ofNullable(clazz.cast(this.minorVersion()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudDirectoryRequest.BuilderImpl
    implements Builder {
        private String developmentSchemaArn;
        private String version;
        private String minorVersion;
        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(PublishSchemaRequest model) {
            super(model);
            this.developmentSchemaArn(model.developmentSchemaArn);
            this.version(model.version);
            this.minorVersion(model.minorVersion);
            this.name(model.name);
        }

        public final String getDevelopmentSchemaArn() {
            return this.developmentSchemaArn;
        }

        @Override
        public final Builder developmentSchemaArn(String developmentSchemaArn) {
            this.developmentSchemaArn = developmentSchemaArn;
            return this;
        }

        public final void setDevelopmentSchemaArn(String developmentSchemaArn) {
            this.developmentSchemaArn = developmentSchemaArn;
        }

        public final String getVersion() {
            return this.version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        public final String getMinorVersion() {
            return this.minorVersion;
        }

        @Override
        public final Builder minorVersion(String minorVersion) {
            this.minorVersion = minorVersion;
            return this;
        }

        public final void setMinorVersion(String minorVersion) {
            this.minorVersion = minorVersion;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PublishSchemaRequest build() {
            return new PublishSchemaRequest(this);
        }
    }

    public static interface Builder
    extends CloudDirectoryRequest.Builder,
    CopyableBuilder<Builder, PublishSchemaRequest> {
        public Builder developmentSchemaArn(String var1);

        public Builder version(String var1);

        public Builder minorVersion(String var1);

        public Builder name(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

