/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.clouddirectory.transform.PolicyAttachmentMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PolicyAttachment
implements StructuredPojo,
ToCopyableBuilder<Builder, PolicyAttachment> {
    private final String policyId;
    private final String objectIdentifier;
    private final String policyType;

    private PolicyAttachment(BuilderImpl builder) {
        this.policyId = builder.policyId;
        this.objectIdentifier = builder.objectIdentifier;
        this.policyType = builder.policyType;
    }

    public String policyId() {
        return this.policyId;
    }

    public String objectIdentifier() {
        return this.objectIdentifier;
    }

    public String policyType() {
        return this.policyType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.policyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.objectIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyType());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PolicyAttachment)) {
            return false;
        }
        PolicyAttachment other = (PolicyAttachment)obj;
        return Objects.equals(this.policyId(), other.policyId()) && Objects.equals(this.objectIdentifier(), other.objectIdentifier()) && Objects.equals(this.policyType(), other.policyType());
    }

    public String toString() {
        return ToString.builder((String)"PolicyAttachment").add("PolicyId", (Object)this.policyId()).add("ObjectIdentifier", (Object)this.objectIdentifier()).add("PolicyType", (Object)this.policyType()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PolicyId": {
                return Optional.ofNullable(clazz.cast(this.policyId()));
            }
            case "ObjectIdentifier": {
                return Optional.ofNullable(clazz.cast(this.objectIdentifier()));
            }
            case "PolicyType": {
                return Optional.ofNullable(clazz.cast(this.policyType()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PolicyAttachmentMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String policyId;
        private String objectIdentifier;
        private String policyType;

        private BuilderImpl() {
        }

        private BuilderImpl(PolicyAttachment model) {
            this.policyId(model.policyId);
            this.objectIdentifier(model.objectIdentifier);
            this.policyType(model.policyType);
        }

        public final String getPolicyId() {
            return this.policyId;
        }

        @Override
        public final Builder policyId(String policyId) {
            this.policyId = policyId;
            return this;
        }

        public final void setPolicyId(String policyId) {
            this.policyId = policyId;
        }

        public final String getObjectIdentifier() {
            return this.objectIdentifier;
        }

        @Override
        public final Builder objectIdentifier(String objectIdentifier) {
            this.objectIdentifier = objectIdentifier;
            return this;
        }

        public final void setObjectIdentifier(String objectIdentifier) {
            this.objectIdentifier = objectIdentifier;
        }

        public final String getPolicyType() {
            return this.policyType;
        }

        @Override
        public final Builder policyType(String policyType) {
            this.policyType = policyType;
            return this;
        }

        public final void setPolicyType(String policyType) {
            this.policyType = policyType;
        }

        public PolicyAttachment build() {
            return new PolicyAttachment(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PolicyAttachment> {
        public Builder policyId(String var1);

        public Builder objectIdentifier(String var1);

        public Builder policyType(String var1);
    }
}

