/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.clouddirectory.model.ObjectIdentifierListCopier;
import software.amazon.awssdk.services.clouddirectory.transform.PathToObjectIdentifiersMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PathToObjectIdentifiers
implements StructuredPojo,
ToCopyableBuilder<Builder, PathToObjectIdentifiers> {
    private final String path;
    private final List<String> objectIdentifiers;

    private PathToObjectIdentifiers(BuilderImpl builder) {
        this.path = builder.path;
        this.objectIdentifiers = builder.objectIdentifiers;
    }

    public String path() {
        return this.path;
    }

    public List<String> objectIdentifiers() {
        return this.objectIdentifiers;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.path());
        hashCode = 31 * hashCode + Objects.hashCode(this.objectIdentifiers());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PathToObjectIdentifiers)) {
            return false;
        }
        PathToObjectIdentifiers other = (PathToObjectIdentifiers)obj;
        return Objects.equals(this.path(), other.path()) && Objects.equals(this.objectIdentifiers(), other.objectIdentifiers());
    }

    public String toString() {
        return ToString.builder((String)"PathToObjectIdentifiers").add("Path", (Object)this.path()).add("ObjectIdentifiers", this.objectIdentifiers()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Path": {
                return Optional.ofNullable(clazz.cast(this.path()));
            }
            case "ObjectIdentifiers": {
                return Optional.ofNullable(clazz.cast(this.objectIdentifiers()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PathToObjectIdentifiersMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String path;
        private List<String> objectIdentifiers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PathToObjectIdentifiers model) {
            this.path(model.path);
            this.objectIdentifiers(model.objectIdentifiers);
        }

        public final String getPath() {
            return this.path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        public final Collection<String> getObjectIdentifiers() {
            return this.objectIdentifiers;
        }

        @Override
        public final Builder objectIdentifiers(Collection<String> objectIdentifiers) {
            this.objectIdentifiers = ObjectIdentifierListCopier.copy(objectIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder objectIdentifiers(String ... objectIdentifiers) {
            this.objectIdentifiers(Arrays.asList(objectIdentifiers));
            return this;
        }

        public final void setObjectIdentifiers(Collection<String> objectIdentifiers) {
            this.objectIdentifiers = ObjectIdentifierListCopier.copy(objectIdentifiers);
        }

        public PathToObjectIdentifiers build() {
            return new PathToObjectIdentifiers(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PathToObjectIdentifiers> {
        public Builder path(String var1);

        public Builder objectIdentifiers(Collection<String> var1);

        public Builder objectIdentifiers(String ... var1);
    }
}

