/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.clouddirectory.model.TypedAttributeValue;
import software.amazon.awssdk.services.clouddirectory.model.UpdateActionType;
import software.amazon.awssdk.services.clouddirectory.transform.ObjectAttributeActionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ObjectAttributeAction
implements StructuredPojo,
ToCopyableBuilder<Builder, ObjectAttributeAction> {
    private final String objectAttributeActionType;
    private final TypedAttributeValue objectAttributeUpdateValue;

    private ObjectAttributeAction(BuilderImpl builder) {
        this.objectAttributeActionType = builder.objectAttributeActionType;
        this.objectAttributeUpdateValue = builder.objectAttributeUpdateValue;
    }

    public UpdateActionType objectAttributeActionType() {
        return UpdateActionType.fromValue(this.objectAttributeActionType);
    }

    public String objectAttributeActionTypeAsString() {
        return this.objectAttributeActionType;
    }

    public TypedAttributeValue objectAttributeUpdateValue() {
        return this.objectAttributeUpdateValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.objectAttributeActionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.objectAttributeUpdateValue());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ObjectAttributeAction)) {
            return false;
        }
        ObjectAttributeAction other = (ObjectAttributeAction)obj;
        return Objects.equals(this.objectAttributeActionTypeAsString(), other.objectAttributeActionTypeAsString()) && Objects.equals(this.objectAttributeUpdateValue(), other.objectAttributeUpdateValue());
    }

    public String toString() {
        return ToString.builder((String)"ObjectAttributeAction").add("ObjectAttributeActionType", (Object)this.objectAttributeActionTypeAsString()).add("ObjectAttributeUpdateValue", (Object)this.objectAttributeUpdateValue()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ObjectAttributeActionType": {
                return Optional.ofNullable(clazz.cast(this.objectAttributeActionTypeAsString()));
            }
            case "ObjectAttributeUpdateValue": {
                return Optional.ofNullable(clazz.cast(this.objectAttributeUpdateValue()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ObjectAttributeActionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String objectAttributeActionType;
        private TypedAttributeValue objectAttributeUpdateValue;

        private BuilderImpl() {
        }

        private BuilderImpl(ObjectAttributeAction model) {
            this.objectAttributeActionType(model.objectAttributeActionType);
            this.objectAttributeUpdateValue(model.objectAttributeUpdateValue);
        }

        public final String getObjectAttributeActionType() {
            return this.objectAttributeActionType;
        }

        @Override
        public final Builder objectAttributeActionType(String objectAttributeActionType) {
            this.objectAttributeActionType = objectAttributeActionType;
            return this;
        }

        @Override
        public final Builder objectAttributeActionType(UpdateActionType objectAttributeActionType) {
            this.objectAttributeActionType(objectAttributeActionType.toString());
            return this;
        }

        public final void setObjectAttributeActionType(String objectAttributeActionType) {
            this.objectAttributeActionType = objectAttributeActionType;
        }

        public final TypedAttributeValue.Builder getObjectAttributeUpdateValue() {
            return this.objectAttributeUpdateValue != null ? this.objectAttributeUpdateValue.toBuilder() : null;
        }

        @Override
        public final Builder objectAttributeUpdateValue(TypedAttributeValue objectAttributeUpdateValue) {
            this.objectAttributeUpdateValue = objectAttributeUpdateValue;
            return this;
        }

        public final void setObjectAttributeUpdateValue(TypedAttributeValue.BuilderImpl objectAttributeUpdateValue) {
            this.objectAttributeUpdateValue = objectAttributeUpdateValue != null ? objectAttributeUpdateValue.build() : null;
        }

        public ObjectAttributeAction build() {
            return new ObjectAttributeAction(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ObjectAttributeAction> {
        public Builder objectAttributeActionType(String var1);

        public Builder objectAttributeActionType(UpdateActionType var1);

        public Builder objectAttributeUpdateValue(TypedAttributeValue var1);

        default public Builder objectAttributeUpdateValue(Consumer<TypedAttributeValue.Builder> objectAttributeUpdateValue) {
            return this.objectAttributeUpdateValue((TypedAttributeValue)((TypedAttributeValue.Builder)TypedAttributeValue.builder().applyMutation(objectAttributeUpdateValue)).build());
        }
    }
}

