/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.clouddirectory.model.CloudDirectoryResponse;
import software.amazon.awssdk.services.clouddirectory.model.TypedLinkNameListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTypedLinkFacetNamesResponse
extends CloudDirectoryResponse
implements ToCopyableBuilder<Builder, ListTypedLinkFacetNamesResponse> {
    private final List<String> facetNames;
    private final String nextToken;

    private ListTypedLinkFacetNamesResponse(BuilderImpl builder) {
        super(builder);
        this.facetNames = builder.facetNames;
        this.nextToken = builder.nextToken;
    }

    public List<String> facetNames() {
        return this.facetNames;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.facetNames());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTypedLinkFacetNamesResponse)) {
            return false;
        }
        ListTypedLinkFacetNamesResponse other = (ListTypedLinkFacetNamesResponse)((Object)obj);
        return Objects.equals(this.facetNames(), other.facetNames()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListTypedLinkFacetNamesResponse").add("FacetNames", this.facetNames()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FacetNames": {
                return Optional.ofNullable(clazz.cast(this.facetNames()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudDirectoryResponse.BuilderImpl
    implements Builder {
        private List<String> facetNames = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTypedLinkFacetNamesResponse model) {
            super(model);
            this.facetNames(model.facetNames);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getFacetNames() {
            return this.facetNames;
        }

        @Override
        public final Builder facetNames(Collection<String> facetNames) {
            this.facetNames = TypedLinkNameListCopier.copy(facetNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder facetNames(String ... facetNames) {
            this.facetNames(Arrays.asList(facetNames));
            return this;
        }

        public final void setFacetNames(Collection<String> facetNames) {
            this.facetNames = TypedLinkNameListCopier.copy(facetNames);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListTypedLinkFacetNamesResponse build() {
            return new ListTypedLinkFacetNamesResponse(this);
        }
    }

    public static interface Builder
    extends CloudDirectoryResponse.Builder,
    CopyableBuilder<Builder, ListTypedLinkFacetNamesResponse> {
        public Builder facetNames(Collection<String> var1);

        public Builder facetNames(String ... var1);

        public Builder nextToken(String var1);
    }
}

