/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.clouddirectory.model.CloudDirectoryResponse;
import software.amazon.awssdk.services.clouddirectory.model.ObjectIdentifierToLinkNameMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListObjectParentsResponse
extends CloudDirectoryResponse
implements ToCopyableBuilder<Builder, ListObjectParentsResponse> {
    private final Map<String, String> parents;
    private final String nextToken;

    private ListObjectParentsResponse(BuilderImpl builder) {
        super(builder);
        this.parents = builder.parents;
        this.nextToken = builder.nextToken;
    }

    public Map<String, String> parents() {
        return this.parents;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.parents());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListObjectParentsResponse)) {
            return false;
        }
        ListObjectParentsResponse other = (ListObjectParentsResponse)((Object)obj);
        return Objects.equals(this.parents(), other.parents()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListObjectParentsResponse").add("Parents", this.parents()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Parents": {
                return Optional.ofNullable(clazz.cast(this.parents()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudDirectoryResponse.BuilderImpl
    implements Builder {
        private Map<String, String> parents = DefaultSdkAutoConstructMap.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListObjectParentsResponse model) {
            super(model);
            this.parents(model.parents);
            this.nextToken(model.nextToken);
        }

        public final Map<String, String> getParents() {
            return this.parents;
        }

        @Override
        public final Builder parents(Map<String, String> parents) {
            this.parents = ObjectIdentifierToLinkNameMapCopier.copy(parents);
            return this;
        }

        public final void setParents(Map<String, String> parents) {
            this.parents = ObjectIdentifierToLinkNameMapCopier.copy(parents);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListObjectParentsResponse build() {
            return new ListObjectParentsResponse(this);
        }
    }

    public static interface Builder
    extends CloudDirectoryResponse.Builder,
    CopyableBuilder<Builder, ListObjectParentsResponse> {
        public Builder parents(Map<String, String> var1);

        public Builder nextToken(String var1);
    }
}

