/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.clouddirectory.model.AttributeKey;
import software.amazon.awssdk.services.clouddirectory.model.LinkAttributeAction;
import software.amazon.awssdk.services.clouddirectory.transform.LinkAttributeUpdateMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LinkAttributeUpdate
implements StructuredPojo,
ToCopyableBuilder<Builder, LinkAttributeUpdate> {
    private final AttributeKey attributeKey;
    private final LinkAttributeAction attributeAction;

    private LinkAttributeUpdate(BuilderImpl builder) {
        this.attributeKey = builder.attributeKey;
        this.attributeAction = builder.attributeAction;
    }

    public AttributeKey attributeKey() {
        return this.attributeKey;
    }

    public LinkAttributeAction attributeAction() {
        return this.attributeAction;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeAction());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LinkAttributeUpdate)) {
            return false;
        }
        LinkAttributeUpdate other = (LinkAttributeUpdate)obj;
        return Objects.equals(this.attributeKey(), other.attributeKey()) && Objects.equals(this.attributeAction(), other.attributeAction());
    }

    public String toString() {
        return ToString.builder((String)"LinkAttributeUpdate").add("AttributeKey", (Object)this.attributeKey()).add("AttributeAction", (Object)this.attributeAction()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AttributeKey": {
                return Optional.ofNullable(clazz.cast(this.attributeKey()));
            }
            case "AttributeAction": {
                return Optional.ofNullable(clazz.cast(this.attributeAction()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LinkAttributeUpdateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private AttributeKey attributeKey;
        private LinkAttributeAction attributeAction;

        private BuilderImpl() {
        }

        private BuilderImpl(LinkAttributeUpdate model) {
            this.attributeKey(model.attributeKey);
            this.attributeAction(model.attributeAction);
        }

        public final AttributeKey.Builder getAttributeKey() {
            return this.attributeKey != null ? this.attributeKey.toBuilder() : null;
        }

        @Override
        public final Builder attributeKey(AttributeKey attributeKey) {
            this.attributeKey = attributeKey;
            return this;
        }

        public final void setAttributeKey(AttributeKey.BuilderImpl attributeKey) {
            this.attributeKey = attributeKey != null ? attributeKey.build() : null;
        }

        public final LinkAttributeAction.Builder getAttributeAction() {
            return this.attributeAction != null ? this.attributeAction.toBuilder() : null;
        }

        @Override
        public final Builder attributeAction(LinkAttributeAction attributeAction) {
            this.attributeAction = attributeAction;
            return this;
        }

        public final void setAttributeAction(LinkAttributeAction.BuilderImpl attributeAction) {
            this.attributeAction = attributeAction != null ? attributeAction.build() : null;
        }

        public LinkAttributeUpdate build() {
            return new LinkAttributeUpdate(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, LinkAttributeUpdate> {
        public Builder attributeKey(AttributeKey var1);

        default public Builder attributeKey(Consumer<AttributeKey.Builder> attributeKey) {
            return this.attributeKey((AttributeKey)((AttributeKey.Builder)AttributeKey.builder().applyMutation(attributeKey)).build());
        }

        public Builder attributeAction(LinkAttributeAction var1);

        default public Builder attributeAction(Consumer<LinkAttributeAction.Builder> attributeAction) {
            return this.attributeAction((LinkAttributeAction)((LinkAttributeAction.Builder)LinkAttributeAction.builder().applyMutation(attributeAction)).build());
        }
    }
}

