/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.clouddirectory.model.TypedAttributeValue;
import software.amazon.awssdk.services.clouddirectory.model.UpdateActionType;
import software.amazon.awssdk.services.clouddirectory.transform.LinkAttributeActionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LinkAttributeAction
implements StructuredPojo,
ToCopyableBuilder<Builder, LinkAttributeAction> {
    private final String attributeActionType;
    private final TypedAttributeValue attributeUpdateValue;

    private LinkAttributeAction(BuilderImpl builder) {
        this.attributeActionType = builder.attributeActionType;
        this.attributeUpdateValue = builder.attributeUpdateValue;
    }

    public UpdateActionType attributeActionType() {
        return UpdateActionType.fromValue(this.attributeActionType);
    }

    public String attributeActionTypeAsString() {
        return this.attributeActionType;
    }

    public TypedAttributeValue attributeUpdateValue() {
        return this.attributeUpdateValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeActionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeUpdateValue());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LinkAttributeAction)) {
            return false;
        }
        LinkAttributeAction other = (LinkAttributeAction)obj;
        return Objects.equals(this.attributeActionTypeAsString(), other.attributeActionTypeAsString()) && Objects.equals(this.attributeUpdateValue(), other.attributeUpdateValue());
    }

    public String toString() {
        return ToString.builder((String)"LinkAttributeAction").add("AttributeActionType", (Object)this.attributeActionTypeAsString()).add("AttributeUpdateValue", (Object)this.attributeUpdateValue()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AttributeActionType": {
                return Optional.ofNullable(clazz.cast(this.attributeActionTypeAsString()));
            }
            case "AttributeUpdateValue": {
                return Optional.ofNullable(clazz.cast(this.attributeUpdateValue()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LinkAttributeActionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String attributeActionType;
        private TypedAttributeValue attributeUpdateValue;

        private BuilderImpl() {
        }

        private BuilderImpl(LinkAttributeAction model) {
            this.attributeActionType(model.attributeActionType);
            this.attributeUpdateValue(model.attributeUpdateValue);
        }

        public final String getAttributeActionType() {
            return this.attributeActionType;
        }

        @Override
        public final Builder attributeActionType(String attributeActionType) {
            this.attributeActionType = attributeActionType;
            return this;
        }

        @Override
        public final Builder attributeActionType(UpdateActionType attributeActionType) {
            this.attributeActionType(attributeActionType.toString());
            return this;
        }

        public final void setAttributeActionType(String attributeActionType) {
            this.attributeActionType = attributeActionType;
        }

        public final TypedAttributeValue.Builder getAttributeUpdateValue() {
            return this.attributeUpdateValue != null ? this.attributeUpdateValue.toBuilder() : null;
        }

        @Override
        public final Builder attributeUpdateValue(TypedAttributeValue attributeUpdateValue) {
            this.attributeUpdateValue = attributeUpdateValue;
            return this;
        }

        public final void setAttributeUpdateValue(TypedAttributeValue.BuilderImpl attributeUpdateValue) {
            this.attributeUpdateValue = attributeUpdateValue != null ? attributeUpdateValue.build() : null;
        }

        public LinkAttributeAction build() {
            return new LinkAttributeAction(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, LinkAttributeAction> {
        public Builder attributeActionType(String var1);

        public Builder attributeActionType(UpdateActionType var1);

        public Builder attributeUpdateValue(TypedAttributeValue var1);

        default public Builder attributeUpdateValue(Consumer<TypedAttributeValue.Builder> attributeUpdateValue) {
            return this.attributeUpdateValue((TypedAttributeValue)((TypedAttributeValue.Builder)TypedAttributeValue.builder().applyMutation(attributeUpdateValue)).build());
        }
    }
}

