/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.clouddirectory.model.AttributeKeyAndValue;
import software.amazon.awssdk.services.clouddirectory.model.AttributeKeyAndValueListCopier;
import software.amazon.awssdk.services.clouddirectory.transform.IndexAttachmentMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IndexAttachment
implements StructuredPojo,
ToCopyableBuilder<Builder, IndexAttachment> {
    private final List<AttributeKeyAndValue> indexedAttributes;
    private final String objectIdentifier;

    private IndexAttachment(BuilderImpl builder) {
        this.indexedAttributes = builder.indexedAttributes;
        this.objectIdentifier = builder.objectIdentifier;
    }

    public List<AttributeKeyAndValue> indexedAttributes() {
        return this.indexedAttributes;
    }

    public String objectIdentifier() {
        return this.objectIdentifier;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.indexedAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.objectIdentifier());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IndexAttachment)) {
            return false;
        }
        IndexAttachment other = (IndexAttachment)obj;
        return Objects.equals(this.indexedAttributes(), other.indexedAttributes()) && Objects.equals(this.objectIdentifier(), other.objectIdentifier());
    }

    public String toString() {
        return ToString.builder((String)"IndexAttachment").add("IndexedAttributes", this.indexedAttributes()).add("ObjectIdentifier", (Object)this.objectIdentifier()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IndexedAttributes": {
                return Optional.ofNullable(clazz.cast(this.indexedAttributes()));
            }
            case "ObjectIdentifier": {
                return Optional.ofNullable(clazz.cast(this.objectIdentifier()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        IndexAttachmentMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private List<AttributeKeyAndValue> indexedAttributes = DefaultSdkAutoConstructList.getInstance();
        private String objectIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(IndexAttachment model) {
            this.indexedAttributes(model.indexedAttributes);
            this.objectIdentifier(model.objectIdentifier);
        }

        public final Collection<AttributeKeyAndValue.Builder> getIndexedAttributes() {
            return this.indexedAttributes != null ? (Collection)this.indexedAttributes.stream().map(AttributeKeyAndValue::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder indexedAttributes(Collection<AttributeKeyAndValue> indexedAttributes) {
            this.indexedAttributes = AttributeKeyAndValueListCopier.copy(indexedAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder indexedAttributes(AttributeKeyAndValue ... indexedAttributes) {
            this.indexedAttributes(Arrays.asList(indexedAttributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder indexedAttributes(Consumer<AttributeKeyAndValue.Builder> ... indexedAttributes) {
            this.indexedAttributes(Stream.of(indexedAttributes).map(c -> (AttributeKeyAndValue)((AttributeKeyAndValue.Builder)AttributeKeyAndValue.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setIndexedAttributes(Collection<AttributeKeyAndValue.BuilderImpl> indexedAttributes) {
            this.indexedAttributes = AttributeKeyAndValueListCopier.copyFromBuilder(indexedAttributes);
        }

        public final String getObjectIdentifier() {
            return this.objectIdentifier;
        }

        @Override
        public final Builder objectIdentifier(String objectIdentifier) {
            this.objectIdentifier = objectIdentifier;
            return this;
        }

        public final void setObjectIdentifier(String objectIdentifier) {
            this.objectIdentifier = objectIdentifier;
        }

        public IndexAttachment build() {
            return new IndexAttachment(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, IndexAttachment> {
        public Builder indexedAttributes(Collection<AttributeKeyAndValue> var1);

        public Builder indexedAttributes(AttributeKeyAndValue ... var1);

        public Builder indexedAttributes(Consumer<AttributeKeyAndValue.Builder> ... var1);

        public Builder objectIdentifier(String var1);
    }
}

