/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.clouddirectory.model.AttributeNameListCopier;
import software.amazon.awssdk.services.clouddirectory.model.CloudDirectoryRequest;
import software.amazon.awssdk.services.clouddirectory.model.ConsistencyLevel;
import software.amazon.awssdk.services.clouddirectory.model.TypedLinkSpecifier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetLinkAttributesRequest
extends CloudDirectoryRequest
implements ToCopyableBuilder<Builder, GetLinkAttributesRequest> {
    private final String directoryArn;
    private final TypedLinkSpecifier typedLinkSpecifier;
    private final List<String> attributeNames;
    private final String consistencyLevel;

    private GetLinkAttributesRequest(BuilderImpl builder) {
        super(builder);
        this.directoryArn = builder.directoryArn;
        this.typedLinkSpecifier = builder.typedLinkSpecifier;
        this.attributeNames = builder.attributeNames;
        this.consistencyLevel = builder.consistencyLevel;
    }

    public String directoryArn() {
        return this.directoryArn;
    }

    public TypedLinkSpecifier typedLinkSpecifier() {
        return this.typedLinkSpecifier;
    }

    public List<String> attributeNames() {
        return this.attributeNames;
    }

    public ConsistencyLevel consistencyLevel() {
        return ConsistencyLevel.fromValue(this.consistencyLevel);
    }

    public String consistencyLevelAsString() {
        return this.consistencyLevel;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.typedLinkSpecifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeNames());
        hashCode = 31 * hashCode + Objects.hashCode(this.consistencyLevelAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLinkAttributesRequest)) {
            return false;
        }
        GetLinkAttributesRequest other = (GetLinkAttributesRequest)((Object)obj);
        return Objects.equals(this.directoryArn(), other.directoryArn()) && Objects.equals(this.typedLinkSpecifier(), other.typedLinkSpecifier()) && Objects.equals(this.attributeNames(), other.attributeNames()) && Objects.equals(this.consistencyLevelAsString(), other.consistencyLevelAsString());
    }

    public String toString() {
        return ToString.builder((String)"GetLinkAttributesRequest").add("DirectoryArn", (Object)this.directoryArn()).add("TypedLinkSpecifier", (Object)this.typedLinkSpecifier()).add("AttributeNames", this.attributeNames()).add("ConsistencyLevel", (Object)this.consistencyLevelAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DirectoryArn": {
                return Optional.ofNullable(clazz.cast(this.directoryArn()));
            }
            case "TypedLinkSpecifier": {
                return Optional.ofNullable(clazz.cast(this.typedLinkSpecifier()));
            }
            case "AttributeNames": {
                return Optional.ofNullable(clazz.cast(this.attributeNames()));
            }
            case "ConsistencyLevel": {
                return Optional.ofNullable(clazz.cast(this.consistencyLevelAsString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudDirectoryRequest.BuilderImpl
    implements Builder {
        private String directoryArn;
        private TypedLinkSpecifier typedLinkSpecifier;
        private List<String> attributeNames = DefaultSdkAutoConstructList.getInstance();
        private String consistencyLevel;

        private BuilderImpl() {
        }

        private BuilderImpl(GetLinkAttributesRequest model) {
            super(model);
            this.directoryArn(model.directoryArn);
            this.typedLinkSpecifier(model.typedLinkSpecifier);
            this.attributeNames(model.attributeNames);
            this.consistencyLevel(model.consistencyLevel);
        }

        public final String getDirectoryArn() {
            return this.directoryArn;
        }

        @Override
        public final Builder directoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
            return this;
        }

        public final void setDirectoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
        }

        public final TypedLinkSpecifier.Builder getTypedLinkSpecifier() {
            return this.typedLinkSpecifier != null ? this.typedLinkSpecifier.toBuilder() : null;
        }

        @Override
        public final Builder typedLinkSpecifier(TypedLinkSpecifier typedLinkSpecifier) {
            this.typedLinkSpecifier = typedLinkSpecifier;
            return this;
        }

        public final void setTypedLinkSpecifier(TypedLinkSpecifier.BuilderImpl typedLinkSpecifier) {
            this.typedLinkSpecifier = typedLinkSpecifier != null ? typedLinkSpecifier.build() : null;
        }

        public final Collection<String> getAttributeNames() {
            return this.attributeNames;
        }

        @Override
        public final Builder attributeNames(Collection<String> attributeNames) {
            this.attributeNames = AttributeNameListCopier.copy(attributeNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeNames(String ... attributeNames) {
            this.attributeNames(Arrays.asList(attributeNames));
            return this;
        }

        public final void setAttributeNames(Collection<String> attributeNames) {
            this.attributeNames = AttributeNameListCopier.copy(attributeNames);
        }

        public final String getConsistencyLevel() {
            return this.consistencyLevel;
        }

        @Override
        public final Builder consistencyLevel(String consistencyLevel) {
            this.consistencyLevel = consistencyLevel;
            return this;
        }

        @Override
        public final Builder consistencyLevel(ConsistencyLevel consistencyLevel) {
            this.consistencyLevel(consistencyLevel.toString());
            return this;
        }

        public final void setConsistencyLevel(String consistencyLevel) {
            this.consistencyLevel = consistencyLevel;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetLinkAttributesRequest build() {
            return new GetLinkAttributesRequest(this);
        }
    }

    public static interface Builder
    extends CloudDirectoryRequest.Builder,
    CopyableBuilder<Builder, GetLinkAttributesRequest> {
        public Builder directoryArn(String var1);

        public Builder typedLinkSpecifier(TypedLinkSpecifier var1);

        default public Builder typedLinkSpecifier(Consumer<TypedLinkSpecifier.Builder> typedLinkSpecifier) {
            return this.typedLinkSpecifier((TypedLinkSpecifier)((TypedLinkSpecifier.Builder)TypedLinkSpecifier.builder().applyMutation(typedLinkSpecifier)).build());
        }

        public Builder attributeNames(Collection<String> var1);

        public Builder attributeNames(String ... var1);

        public Builder consistencyLevel(String var1);

        public Builder consistencyLevel(ConsistencyLevel var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

