/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.clouddirectory.model.BatchAddFacetToObjectResponse;
import software.amazon.awssdk.services.clouddirectory.model.BatchAttachObjectResponse;
import software.amazon.awssdk.services.clouddirectory.model.BatchAttachPolicyResponse;
import software.amazon.awssdk.services.clouddirectory.model.BatchAttachToIndexResponse;
import software.amazon.awssdk.services.clouddirectory.model.BatchAttachTypedLinkResponse;
import software.amazon.awssdk.services.clouddirectory.model.BatchCreateIndexResponse;
import software.amazon.awssdk.services.clouddirectory.model.BatchCreateObjectResponse;
import software.amazon.awssdk.services.clouddirectory.model.BatchDeleteObjectResponse;
import software.amazon.awssdk.services.clouddirectory.model.BatchDetachFromIndexResponse;
import software.amazon.awssdk.services.clouddirectory.model.BatchDetachObjectResponse;
import software.amazon.awssdk.services.clouddirectory.model.BatchDetachPolicyResponse;
import software.amazon.awssdk.services.clouddirectory.model.BatchDetachTypedLinkResponse;
import software.amazon.awssdk.services.clouddirectory.model.BatchRemoveFacetFromObjectResponse;
import software.amazon.awssdk.services.clouddirectory.model.BatchUpdateLinkAttributesResponse;
import software.amazon.awssdk.services.clouddirectory.model.BatchUpdateObjectAttributesResponse;
import software.amazon.awssdk.services.clouddirectory.transform.BatchWriteOperationResponseMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchWriteOperationResponse
implements StructuredPojo,
ToCopyableBuilder<Builder, BatchWriteOperationResponse> {
    private final BatchCreateObjectResponse createObject;
    private final BatchAttachObjectResponse attachObject;
    private final BatchDetachObjectResponse detachObject;
    private final BatchUpdateObjectAttributesResponse updateObjectAttributes;
    private final BatchDeleteObjectResponse deleteObject;
    private final BatchAddFacetToObjectResponse addFacetToObject;
    private final BatchRemoveFacetFromObjectResponse removeFacetFromObject;
    private final BatchAttachPolicyResponse attachPolicy;
    private final BatchDetachPolicyResponse detachPolicy;
    private final BatchCreateIndexResponse createIndex;
    private final BatchAttachToIndexResponse attachToIndex;
    private final BatchDetachFromIndexResponse detachFromIndex;
    private final BatchAttachTypedLinkResponse attachTypedLink;
    private final BatchDetachTypedLinkResponse detachTypedLink;
    private final BatchUpdateLinkAttributesResponse updateLinkAttributes;

    private BatchWriteOperationResponse(BuilderImpl builder) {
        this.createObject = builder.createObject;
        this.attachObject = builder.attachObject;
        this.detachObject = builder.detachObject;
        this.updateObjectAttributes = builder.updateObjectAttributes;
        this.deleteObject = builder.deleteObject;
        this.addFacetToObject = builder.addFacetToObject;
        this.removeFacetFromObject = builder.removeFacetFromObject;
        this.attachPolicy = builder.attachPolicy;
        this.detachPolicy = builder.detachPolicy;
        this.createIndex = builder.createIndex;
        this.attachToIndex = builder.attachToIndex;
        this.detachFromIndex = builder.detachFromIndex;
        this.attachTypedLink = builder.attachTypedLink;
        this.detachTypedLink = builder.detachTypedLink;
        this.updateLinkAttributes = builder.updateLinkAttributes;
    }

    public BatchCreateObjectResponse createObject() {
        return this.createObject;
    }

    public BatchAttachObjectResponse attachObject() {
        return this.attachObject;
    }

    public BatchDetachObjectResponse detachObject() {
        return this.detachObject;
    }

    public BatchUpdateObjectAttributesResponse updateObjectAttributes() {
        return this.updateObjectAttributes;
    }

    public BatchDeleteObjectResponse deleteObject() {
        return this.deleteObject;
    }

    public BatchAddFacetToObjectResponse addFacetToObject() {
        return this.addFacetToObject;
    }

    public BatchRemoveFacetFromObjectResponse removeFacetFromObject() {
        return this.removeFacetFromObject;
    }

    public BatchAttachPolicyResponse attachPolicy() {
        return this.attachPolicy;
    }

    public BatchDetachPolicyResponse detachPolicy() {
        return this.detachPolicy;
    }

    public BatchCreateIndexResponse createIndex() {
        return this.createIndex;
    }

    public BatchAttachToIndexResponse attachToIndex() {
        return this.attachToIndex;
    }

    public BatchDetachFromIndexResponse detachFromIndex() {
        return this.detachFromIndex;
    }

    public BatchAttachTypedLinkResponse attachTypedLink() {
        return this.attachTypedLink;
    }

    public BatchDetachTypedLinkResponse detachTypedLink() {
        return this.detachTypedLink;
    }

    public BatchUpdateLinkAttributesResponse updateLinkAttributes() {
        return this.updateLinkAttributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.createObject());
        hashCode = 31 * hashCode + Objects.hashCode(this.attachObject());
        hashCode = 31 * hashCode + Objects.hashCode(this.detachObject());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateObjectAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.deleteObject());
        hashCode = 31 * hashCode + Objects.hashCode(this.addFacetToObject());
        hashCode = 31 * hashCode + Objects.hashCode(this.removeFacetFromObject());
        hashCode = 31 * hashCode + Objects.hashCode(this.attachPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.detachPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.createIndex());
        hashCode = 31 * hashCode + Objects.hashCode(this.attachToIndex());
        hashCode = 31 * hashCode + Objects.hashCode(this.detachFromIndex());
        hashCode = 31 * hashCode + Objects.hashCode(this.attachTypedLink());
        hashCode = 31 * hashCode + Objects.hashCode(this.detachTypedLink());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateLinkAttributes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchWriteOperationResponse)) {
            return false;
        }
        BatchWriteOperationResponse other = (BatchWriteOperationResponse)obj;
        return Objects.equals(this.createObject(), other.createObject()) && Objects.equals(this.attachObject(), other.attachObject()) && Objects.equals(this.detachObject(), other.detachObject()) && Objects.equals(this.updateObjectAttributes(), other.updateObjectAttributes()) && Objects.equals(this.deleteObject(), other.deleteObject()) && Objects.equals(this.addFacetToObject(), other.addFacetToObject()) && Objects.equals(this.removeFacetFromObject(), other.removeFacetFromObject()) && Objects.equals(this.attachPolicy(), other.attachPolicy()) && Objects.equals(this.detachPolicy(), other.detachPolicy()) && Objects.equals(this.createIndex(), other.createIndex()) && Objects.equals(this.attachToIndex(), other.attachToIndex()) && Objects.equals(this.detachFromIndex(), other.detachFromIndex()) && Objects.equals(this.attachTypedLink(), other.attachTypedLink()) && Objects.equals(this.detachTypedLink(), other.detachTypedLink()) && Objects.equals(this.updateLinkAttributes(), other.updateLinkAttributes());
    }

    public String toString() {
        return ToString.builder((String)"BatchWriteOperationResponse").add("CreateObject", (Object)this.createObject()).add("AttachObject", (Object)this.attachObject()).add("DetachObject", (Object)this.detachObject()).add("UpdateObjectAttributes", (Object)this.updateObjectAttributes()).add("DeleteObject", (Object)this.deleteObject()).add("AddFacetToObject", (Object)this.addFacetToObject()).add("RemoveFacetFromObject", (Object)this.removeFacetFromObject()).add("AttachPolicy", (Object)this.attachPolicy()).add("DetachPolicy", (Object)this.detachPolicy()).add("CreateIndex", (Object)this.createIndex()).add("AttachToIndex", (Object)this.attachToIndex()).add("DetachFromIndex", (Object)this.detachFromIndex()).add("AttachTypedLink", (Object)this.attachTypedLink()).add("DetachTypedLink", (Object)this.detachTypedLink()).add("UpdateLinkAttributes", (Object)this.updateLinkAttributes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CreateObject": {
                return Optional.ofNullable(clazz.cast(this.createObject()));
            }
            case "AttachObject": {
                return Optional.ofNullable(clazz.cast(this.attachObject()));
            }
            case "DetachObject": {
                return Optional.ofNullable(clazz.cast(this.detachObject()));
            }
            case "UpdateObjectAttributes": {
                return Optional.ofNullable(clazz.cast(this.updateObjectAttributes()));
            }
            case "DeleteObject": {
                return Optional.ofNullable(clazz.cast(this.deleteObject()));
            }
            case "AddFacetToObject": {
                return Optional.ofNullable(clazz.cast(this.addFacetToObject()));
            }
            case "RemoveFacetFromObject": {
                return Optional.ofNullable(clazz.cast(this.removeFacetFromObject()));
            }
            case "AttachPolicy": {
                return Optional.ofNullable(clazz.cast(this.attachPolicy()));
            }
            case "DetachPolicy": {
                return Optional.ofNullable(clazz.cast(this.detachPolicy()));
            }
            case "CreateIndex": {
                return Optional.ofNullable(clazz.cast(this.createIndex()));
            }
            case "AttachToIndex": {
                return Optional.ofNullable(clazz.cast(this.attachToIndex()));
            }
            case "DetachFromIndex": {
                return Optional.ofNullable(clazz.cast(this.detachFromIndex()));
            }
            case "AttachTypedLink": {
                return Optional.ofNullable(clazz.cast(this.attachTypedLink()));
            }
            case "DetachTypedLink": {
                return Optional.ofNullable(clazz.cast(this.detachTypedLink()));
            }
            case "UpdateLinkAttributes": {
                return Optional.ofNullable(clazz.cast(this.updateLinkAttributes()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BatchWriteOperationResponseMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private BatchCreateObjectResponse createObject;
        private BatchAttachObjectResponse attachObject;
        private BatchDetachObjectResponse detachObject;
        private BatchUpdateObjectAttributesResponse updateObjectAttributes;
        private BatchDeleteObjectResponse deleteObject;
        private BatchAddFacetToObjectResponse addFacetToObject;
        private BatchRemoveFacetFromObjectResponse removeFacetFromObject;
        private BatchAttachPolicyResponse attachPolicy;
        private BatchDetachPolicyResponse detachPolicy;
        private BatchCreateIndexResponse createIndex;
        private BatchAttachToIndexResponse attachToIndex;
        private BatchDetachFromIndexResponse detachFromIndex;
        private BatchAttachTypedLinkResponse attachTypedLink;
        private BatchDetachTypedLinkResponse detachTypedLink;
        private BatchUpdateLinkAttributesResponse updateLinkAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchWriteOperationResponse model) {
            this.createObject(model.createObject);
            this.attachObject(model.attachObject);
            this.detachObject(model.detachObject);
            this.updateObjectAttributes(model.updateObjectAttributes);
            this.deleteObject(model.deleteObject);
            this.addFacetToObject(model.addFacetToObject);
            this.removeFacetFromObject(model.removeFacetFromObject);
            this.attachPolicy(model.attachPolicy);
            this.detachPolicy(model.detachPolicy);
            this.createIndex(model.createIndex);
            this.attachToIndex(model.attachToIndex);
            this.detachFromIndex(model.detachFromIndex);
            this.attachTypedLink(model.attachTypedLink);
            this.detachTypedLink(model.detachTypedLink);
            this.updateLinkAttributes(model.updateLinkAttributes);
        }

        public final BatchCreateObjectResponse.Builder getCreateObject() {
            return this.createObject != null ? this.createObject.toBuilder() : null;
        }

        @Override
        public final Builder createObject(BatchCreateObjectResponse createObject) {
            this.createObject = createObject;
            return this;
        }

        public final void setCreateObject(BatchCreateObjectResponse.BuilderImpl createObject) {
            this.createObject = createObject != null ? createObject.build() : null;
        }

        public final BatchAttachObjectResponse.Builder getAttachObject() {
            return this.attachObject != null ? this.attachObject.toBuilder() : null;
        }

        @Override
        public final Builder attachObject(BatchAttachObjectResponse attachObject) {
            this.attachObject = attachObject;
            return this;
        }

        public final void setAttachObject(BatchAttachObjectResponse.BuilderImpl attachObject) {
            this.attachObject = attachObject != null ? attachObject.build() : null;
        }

        public final BatchDetachObjectResponse.Builder getDetachObject() {
            return this.detachObject != null ? this.detachObject.toBuilder() : null;
        }

        @Override
        public final Builder detachObject(BatchDetachObjectResponse detachObject) {
            this.detachObject = detachObject;
            return this;
        }

        public final void setDetachObject(BatchDetachObjectResponse.BuilderImpl detachObject) {
            this.detachObject = detachObject != null ? detachObject.build() : null;
        }

        public final BatchUpdateObjectAttributesResponse.Builder getUpdateObjectAttributes() {
            return this.updateObjectAttributes != null ? this.updateObjectAttributes.toBuilder() : null;
        }

        @Override
        public final Builder updateObjectAttributes(BatchUpdateObjectAttributesResponse updateObjectAttributes) {
            this.updateObjectAttributes = updateObjectAttributes;
            return this;
        }

        public final void setUpdateObjectAttributes(BatchUpdateObjectAttributesResponse.BuilderImpl updateObjectAttributes) {
            this.updateObjectAttributes = updateObjectAttributes != null ? updateObjectAttributes.build() : null;
        }

        public final BatchDeleteObjectResponse.Builder getDeleteObject() {
            return this.deleteObject != null ? this.deleteObject.toBuilder() : null;
        }

        @Override
        public final Builder deleteObject(BatchDeleteObjectResponse deleteObject) {
            this.deleteObject = deleteObject;
            return this;
        }

        public final void setDeleteObject(BatchDeleteObjectResponse.BuilderImpl deleteObject) {
            this.deleteObject = deleteObject != null ? deleteObject.build() : null;
        }

        public final BatchAddFacetToObjectResponse.Builder getAddFacetToObject() {
            return this.addFacetToObject != null ? this.addFacetToObject.toBuilder() : null;
        }

        @Override
        public final Builder addFacetToObject(BatchAddFacetToObjectResponse addFacetToObject) {
            this.addFacetToObject = addFacetToObject;
            return this;
        }

        public final void setAddFacetToObject(BatchAddFacetToObjectResponse.BuilderImpl addFacetToObject) {
            this.addFacetToObject = addFacetToObject != null ? addFacetToObject.build() : null;
        }

        public final BatchRemoveFacetFromObjectResponse.Builder getRemoveFacetFromObject() {
            return this.removeFacetFromObject != null ? this.removeFacetFromObject.toBuilder() : null;
        }

        @Override
        public final Builder removeFacetFromObject(BatchRemoveFacetFromObjectResponse removeFacetFromObject) {
            this.removeFacetFromObject = removeFacetFromObject;
            return this;
        }

        public final void setRemoveFacetFromObject(BatchRemoveFacetFromObjectResponse.BuilderImpl removeFacetFromObject) {
            this.removeFacetFromObject = removeFacetFromObject != null ? removeFacetFromObject.build() : null;
        }

        public final BatchAttachPolicyResponse.Builder getAttachPolicy() {
            return this.attachPolicy != null ? this.attachPolicy.toBuilder() : null;
        }

        @Override
        public final Builder attachPolicy(BatchAttachPolicyResponse attachPolicy) {
            this.attachPolicy = attachPolicy;
            return this;
        }

        public final void setAttachPolicy(BatchAttachPolicyResponse.BuilderImpl attachPolicy) {
            this.attachPolicy = attachPolicy != null ? attachPolicy.build() : null;
        }

        public final BatchDetachPolicyResponse.Builder getDetachPolicy() {
            return this.detachPolicy != null ? this.detachPolicy.toBuilder() : null;
        }

        @Override
        public final Builder detachPolicy(BatchDetachPolicyResponse detachPolicy) {
            this.detachPolicy = detachPolicy;
            return this;
        }

        public final void setDetachPolicy(BatchDetachPolicyResponse.BuilderImpl detachPolicy) {
            this.detachPolicy = detachPolicy != null ? detachPolicy.build() : null;
        }

        public final BatchCreateIndexResponse.Builder getCreateIndex() {
            return this.createIndex != null ? this.createIndex.toBuilder() : null;
        }

        @Override
        public final Builder createIndex(BatchCreateIndexResponse createIndex) {
            this.createIndex = createIndex;
            return this;
        }

        public final void setCreateIndex(BatchCreateIndexResponse.BuilderImpl createIndex) {
            this.createIndex = createIndex != null ? createIndex.build() : null;
        }

        public final BatchAttachToIndexResponse.Builder getAttachToIndex() {
            return this.attachToIndex != null ? this.attachToIndex.toBuilder() : null;
        }

        @Override
        public final Builder attachToIndex(BatchAttachToIndexResponse attachToIndex) {
            this.attachToIndex = attachToIndex;
            return this;
        }

        public final void setAttachToIndex(BatchAttachToIndexResponse.BuilderImpl attachToIndex) {
            this.attachToIndex = attachToIndex != null ? attachToIndex.build() : null;
        }

        public final BatchDetachFromIndexResponse.Builder getDetachFromIndex() {
            return this.detachFromIndex != null ? this.detachFromIndex.toBuilder() : null;
        }

        @Override
        public final Builder detachFromIndex(BatchDetachFromIndexResponse detachFromIndex) {
            this.detachFromIndex = detachFromIndex;
            return this;
        }

        public final void setDetachFromIndex(BatchDetachFromIndexResponse.BuilderImpl detachFromIndex) {
            this.detachFromIndex = detachFromIndex != null ? detachFromIndex.build() : null;
        }

        public final BatchAttachTypedLinkResponse.Builder getAttachTypedLink() {
            return this.attachTypedLink != null ? this.attachTypedLink.toBuilder() : null;
        }

        @Override
        public final Builder attachTypedLink(BatchAttachTypedLinkResponse attachTypedLink) {
            this.attachTypedLink = attachTypedLink;
            return this;
        }

        public final void setAttachTypedLink(BatchAttachTypedLinkResponse.BuilderImpl attachTypedLink) {
            this.attachTypedLink = attachTypedLink != null ? attachTypedLink.build() : null;
        }

        public final BatchDetachTypedLinkResponse.Builder getDetachTypedLink() {
            return this.detachTypedLink != null ? this.detachTypedLink.toBuilder() : null;
        }

        @Override
        public final Builder detachTypedLink(BatchDetachTypedLinkResponse detachTypedLink) {
            this.detachTypedLink = detachTypedLink;
            return this;
        }

        public final void setDetachTypedLink(BatchDetachTypedLinkResponse.BuilderImpl detachTypedLink) {
            this.detachTypedLink = detachTypedLink != null ? detachTypedLink.build() : null;
        }

        public final BatchUpdateLinkAttributesResponse.Builder getUpdateLinkAttributes() {
            return this.updateLinkAttributes != null ? this.updateLinkAttributes.toBuilder() : null;
        }

        @Override
        public final Builder updateLinkAttributes(BatchUpdateLinkAttributesResponse updateLinkAttributes) {
            this.updateLinkAttributes = updateLinkAttributes;
            return this;
        }

        public final void setUpdateLinkAttributes(BatchUpdateLinkAttributesResponse.BuilderImpl updateLinkAttributes) {
            this.updateLinkAttributes = updateLinkAttributes != null ? updateLinkAttributes.build() : null;
        }

        public BatchWriteOperationResponse build() {
            return new BatchWriteOperationResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BatchWriteOperationResponse> {
        public Builder createObject(BatchCreateObjectResponse var1);

        default public Builder createObject(Consumer<BatchCreateObjectResponse.Builder> createObject) {
            return this.createObject((BatchCreateObjectResponse)((BatchCreateObjectResponse.Builder)BatchCreateObjectResponse.builder().applyMutation(createObject)).build());
        }

        public Builder attachObject(BatchAttachObjectResponse var1);

        default public Builder attachObject(Consumer<BatchAttachObjectResponse.Builder> attachObject) {
            return this.attachObject((BatchAttachObjectResponse)((BatchAttachObjectResponse.Builder)BatchAttachObjectResponse.builder().applyMutation(attachObject)).build());
        }

        public Builder detachObject(BatchDetachObjectResponse var1);

        default public Builder detachObject(Consumer<BatchDetachObjectResponse.Builder> detachObject) {
            return this.detachObject((BatchDetachObjectResponse)((BatchDetachObjectResponse.Builder)BatchDetachObjectResponse.builder().applyMutation(detachObject)).build());
        }

        public Builder updateObjectAttributes(BatchUpdateObjectAttributesResponse var1);

        default public Builder updateObjectAttributes(Consumer<BatchUpdateObjectAttributesResponse.Builder> updateObjectAttributes) {
            return this.updateObjectAttributes((BatchUpdateObjectAttributesResponse)((BatchUpdateObjectAttributesResponse.Builder)BatchUpdateObjectAttributesResponse.builder().applyMutation(updateObjectAttributes)).build());
        }

        public Builder deleteObject(BatchDeleteObjectResponse var1);

        default public Builder deleteObject(Consumer<BatchDeleteObjectResponse.Builder> deleteObject) {
            return this.deleteObject((BatchDeleteObjectResponse)((BatchDeleteObjectResponse.Builder)BatchDeleteObjectResponse.builder().applyMutation(deleteObject)).build());
        }

        public Builder addFacetToObject(BatchAddFacetToObjectResponse var1);

        default public Builder addFacetToObject(Consumer<BatchAddFacetToObjectResponse.Builder> addFacetToObject) {
            return this.addFacetToObject((BatchAddFacetToObjectResponse)((BatchAddFacetToObjectResponse.Builder)BatchAddFacetToObjectResponse.builder().applyMutation(addFacetToObject)).build());
        }

        public Builder removeFacetFromObject(BatchRemoveFacetFromObjectResponse var1);

        default public Builder removeFacetFromObject(Consumer<BatchRemoveFacetFromObjectResponse.Builder> removeFacetFromObject) {
            return this.removeFacetFromObject((BatchRemoveFacetFromObjectResponse)((BatchRemoveFacetFromObjectResponse.Builder)BatchRemoveFacetFromObjectResponse.builder().applyMutation(removeFacetFromObject)).build());
        }

        public Builder attachPolicy(BatchAttachPolicyResponse var1);

        default public Builder attachPolicy(Consumer<BatchAttachPolicyResponse.Builder> attachPolicy) {
            return this.attachPolicy((BatchAttachPolicyResponse)((BatchAttachPolicyResponse.Builder)BatchAttachPolicyResponse.builder().applyMutation(attachPolicy)).build());
        }

        public Builder detachPolicy(BatchDetachPolicyResponse var1);

        default public Builder detachPolicy(Consumer<BatchDetachPolicyResponse.Builder> detachPolicy) {
            return this.detachPolicy((BatchDetachPolicyResponse)((BatchDetachPolicyResponse.Builder)BatchDetachPolicyResponse.builder().applyMutation(detachPolicy)).build());
        }

        public Builder createIndex(BatchCreateIndexResponse var1);

        default public Builder createIndex(Consumer<BatchCreateIndexResponse.Builder> createIndex) {
            return this.createIndex((BatchCreateIndexResponse)((BatchCreateIndexResponse.Builder)BatchCreateIndexResponse.builder().applyMutation(createIndex)).build());
        }

        public Builder attachToIndex(BatchAttachToIndexResponse var1);

        default public Builder attachToIndex(Consumer<BatchAttachToIndexResponse.Builder> attachToIndex) {
            return this.attachToIndex((BatchAttachToIndexResponse)((BatchAttachToIndexResponse.Builder)BatchAttachToIndexResponse.builder().applyMutation(attachToIndex)).build());
        }

        public Builder detachFromIndex(BatchDetachFromIndexResponse var1);

        default public Builder detachFromIndex(Consumer<BatchDetachFromIndexResponse.Builder> detachFromIndex) {
            return this.detachFromIndex((BatchDetachFromIndexResponse)((BatchDetachFromIndexResponse.Builder)BatchDetachFromIndexResponse.builder().applyMutation(detachFromIndex)).build());
        }

        public Builder attachTypedLink(BatchAttachTypedLinkResponse var1);

        default public Builder attachTypedLink(Consumer<BatchAttachTypedLinkResponse.Builder> attachTypedLink) {
            return this.attachTypedLink((BatchAttachTypedLinkResponse)((BatchAttachTypedLinkResponse.Builder)BatchAttachTypedLinkResponse.builder().applyMutation(attachTypedLink)).build());
        }

        public Builder detachTypedLink(BatchDetachTypedLinkResponse var1);

        default public Builder detachTypedLink(Consumer<BatchDetachTypedLinkResponse.Builder> detachTypedLink) {
            return this.detachTypedLink((BatchDetachTypedLinkResponse)((BatchDetachTypedLinkResponse.Builder)BatchDetachTypedLinkResponse.builder().applyMutation(detachTypedLink)).build());
        }

        public Builder updateLinkAttributes(BatchUpdateLinkAttributesResponse var1);

        default public Builder updateLinkAttributes(Consumer<BatchUpdateLinkAttributesResponse.Builder> updateLinkAttributes) {
            return this.updateLinkAttributes((BatchUpdateLinkAttributesResponse)((BatchUpdateLinkAttributesResponse.Builder)BatchUpdateLinkAttributesResponse.builder().applyMutation(updateLinkAttributes)).build());
        }
    }
}

