/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.clouddirectory.model.TypedLinkSpecifier;
import software.amazon.awssdk.services.clouddirectory.model.TypedLinkSpecifierListCopier;
import software.amazon.awssdk.services.clouddirectory.transform.BatchListOutgoingTypedLinksResponseMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchListOutgoingTypedLinksResponse
implements StructuredPojo,
ToCopyableBuilder<Builder, BatchListOutgoingTypedLinksResponse> {
    private final List<TypedLinkSpecifier> typedLinkSpecifiers;
    private final String nextToken;

    private BatchListOutgoingTypedLinksResponse(BuilderImpl builder) {
        this.typedLinkSpecifiers = builder.typedLinkSpecifiers;
        this.nextToken = builder.nextToken;
    }

    public List<TypedLinkSpecifier> typedLinkSpecifiers() {
        return this.typedLinkSpecifiers;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typedLinkSpecifiers());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchListOutgoingTypedLinksResponse)) {
            return false;
        }
        BatchListOutgoingTypedLinksResponse other = (BatchListOutgoingTypedLinksResponse)obj;
        return Objects.equals(this.typedLinkSpecifiers(), other.typedLinkSpecifiers()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"BatchListOutgoingTypedLinksResponse").add("TypedLinkSpecifiers", this.typedLinkSpecifiers()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TypedLinkSpecifiers": {
                return Optional.ofNullable(clazz.cast(this.typedLinkSpecifiers()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BatchListOutgoingTypedLinksResponseMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private List<TypedLinkSpecifier> typedLinkSpecifiers = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchListOutgoingTypedLinksResponse model) {
            this.typedLinkSpecifiers(model.typedLinkSpecifiers);
            this.nextToken(model.nextToken);
        }

        public final Collection<TypedLinkSpecifier.Builder> getTypedLinkSpecifiers() {
            return this.typedLinkSpecifiers != null ? (Collection)this.typedLinkSpecifiers.stream().map(TypedLinkSpecifier::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder typedLinkSpecifiers(Collection<TypedLinkSpecifier> typedLinkSpecifiers) {
            this.typedLinkSpecifiers = TypedLinkSpecifierListCopier.copy(typedLinkSpecifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder typedLinkSpecifiers(TypedLinkSpecifier ... typedLinkSpecifiers) {
            this.typedLinkSpecifiers(Arrays.asList(typedLinkSpecifiers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder typedLinkSpecifiers(Consumer<TypedLinkSpecifier.Builder> ... typedLinkSpecifiers) {
            this.typedLinkSpecifiers(Stream.of(typedLinkSpecifiers).map(c -> (TypedLinkSpecifier)((TypedLinkSpecifier.Builder)TypedLinkSpecifier.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTypedLinkSpecifiers(Collection<TypedLinkSpecifier.BuilderImpl> typedLinkSpecifiers) {
            this.typedLinkSpecifiers = TypedLinkSpecifierListCopier.copyFromBuilder(typedLinkSpecifiers);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public BatchListOutgoingTypedLinksResponse build() {
            return new BatchListOutgoingTypedLinksResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BatchListOutgoingTypedLinksResponse> {
        public Builder typedLinkSpecifiers(Collection<TypedLinkSpecifier> var1);

        public Builder typedLinkSpecifiers(TypedLinkSpecifier ... var1);

        public Builder typedLinkSpecifiers(Consumer<TypedLinkSpecifier.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

