/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.clouddirectory.model.ObjectReference;
import software.amazon.awssdk.services.clouddirectory.transform.BatchListAttachedIndicesMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchListAttachedIndices
implements StructuredPojo,
ToCopyableBuilder<Builder, BatchListAttachedIndices> {
    private final ObjectReference targetReference;
    private final String nextToken;
    private final Integer maxResults;

    private BatchListAttachedIndices(BuilderImpl builder) {
        this.targetReference = builder.targetReference;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public ObjectReference targetReference() {
        return this.targetReference;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.targetReference());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchListAttachedIndices)) {
            return false;
        }
        BatchListAttachedIndices other = (BatchListAttachedIndices)obj;
        return Objects.equals(this.targetReference(), other.targetReference()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public String toString() {
        return ToString.builder((String)"BatchListAttachedIndices").add("TargetReference", (Object)this.targetReference()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TargetReference": {
                return Optional.ofNullable(clazz.cast(this.targetReference()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BatchListAttachedIndicesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private ObjectReference targetReference;
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchListAttachedIndices model) {
            this.targetReference(model.targetReference);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final ObjectReference.Builder getTargetReference() {
            return this.targetReference != null ? this.targetReference.toBuilder() : null;
        }

        @Override
        public final Builder targetReference(ObjectReference targetReference) {
            this.targetReference = targetReference;
            return this;
        }

        public final void setTargetReference(ObjectReference.BuilderImpl targetReference) {
            this.targetReference = targetReference != null ? targetReference.build() : null;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public BatchListAttachedIndices build() {
            return new BatchListAttachedIndices(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BatchListAttachedIndices> {
        public Builder targetReference(ObjectReference var1);

        default public Builder targetReference(Consumer<ObjectReference.Builder> targetReference) {
            return this.targetReference((ObjectReference)((ObjectReference.Builder)ObjectReference.builder().applyMutation(targetReference)).build());
        }

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);
    }
}

