/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.clouddirectory.model.ObjectReference;
import software.amazon.awssdk.services.clouddirectory.transform.BatchDetachPolicyMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchDetachPolicy
implements StructuredPojo,
ToCopyableBuilder<Builder, BatchDetachPolicy> {
    private final ObjectReference policyReference;
    private final ObjectReference objectReference;

    private BatchDetachPolicy(BuilderImpl builder) {
        this.policyReference = builder.policyReference;
        this.objectReference = builder.objectReference;
    }

    public ObjectReference policyReference() {
        return this.policyReference;
    }

    public ObjectReference objectReference() {
        return this.objectReference;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.policyReference());
        hashCode = 31 * hashCode + Objects.hashCode(this.objectReference());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDetachPolicy)) {
            return false;
        }
        BatchDetachPolicy other = (BatchDetachPolicy)obj;
        return Objects.equals(this.policyReference(), other.policyReference()) && Objects.equals(this.objectReference(), other.objectReference());
    }

    public String toString() {
        return ToString.builder((String)"BatchDetachPolicy").add("PolicyReference", (Object)this.policyReference()).add("ObjectReference", (Object)this.objectReference()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PolicyReference": {
                return Optional.ofNullable(clazz.cast(this.policyReference()));
            }
            case "ObjectReference": {
                return Optional.ofNullable(clazz.cast(this.objectReference()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BatchDetachPolicyMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private ObjectReference policyReference;
        private ObjectReference objectReference;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDetachPolicy model) {
            this.policyReference(model.policyReference);
            this.objectReference(model.objectReference);
        }

        public final ObjectReference.Builder getPolicyReference() {
            return this.policyReference != null ? this.policyReference.toBuilder() : null;
        }

        @Override
        public final Builder policyReference(ObjectReference policyReference) {
            this.policyReference = policyReference;
            return this;
        }

        public final void setPolicyReference(ObjectReference.BuilderImpl policyReference) {
            this.policyReference = policyReference != null ? policyReference.build() : null;
        }

        public final ObjectReference.Builder getObjectReference() {
            return this.objectReference != null ? this.objectReference.toBuilder() : null;
        }

        @Override
        public final Builder objectReference(ObjectReference objectReference) {
            this.objectReference = objectReference;
            return this;
        }

        public final void setObjectReference(ObjectReference.BuilderImpl objectReference) {
            this.objectReference = objectReference != null ? objectReference.build() : null;
        }

        public BatchDetachPolicy build() {
            return new BatchDetachPolicy(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BatchDetachPolicy> {
        public Builder policyReference(ObjectReference var1);

        default public Builder policyReference(Consumer<ObjectReference.Builder> policyReference) {
            return this.policyReference((ObjectReference)((ObjectReference.Builder)ObjectReference.builder().applyMutation(policyReference)).build());
        }

        public Builder objectReference(ObjectReference var1);

        default public Builder objectReference(Consumer<ObjectReference.Builder> objectReference) {
            return this.objectReference((ObjectReference)((ObjectReference.Builder)ObjectReference.builder().applyMutation(objectReference)).build());
        }
    }
}

