/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.clouddirectory.model.ObjectReference;
import software.amazon.awssdk.services.clouddirectory.transform.BatchAttachObjectMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchAttachObject
implements StructuredPojo,
ToCopyableBuilder<Builder, BatchAttachObject> {
    private final ObjectReference parentReference;
    private final ObjectReference childReference;
    private final String linkName;

    private BatchAttachObject(BuilderImpl builder) {
        this.parentReference = builder.parentReference;
        this.childReference = builder.childReference;
        this.linkName = builder.linkName;
    }

    public ObjectReference parentReference() {
        return this.parentReference;
    }

    public ObjectReference childReference() {
        return this.childReference;
    }

    public String linkName() {
        return this.linkName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.parentReference());
        hashCode = 31 * hashCode + Objects.hashCode(this.childReference());
        hashCode = 31 * hashCode + Objects.hashCode(this.linkName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchAttachObject)) {
            return false;
        }
        BatchAttachObject other = (BatchAttachObject)obj;
        return Objects.equals(this.parentReference(), other.parentReference()) && Objects.equals(this.childReference(), other.childReference()) && Objects.equals(this.linkName(), other.linkName());
    }

    public String toString() {
        return ToString.builder((String)"BatchAttachObject").add("ParentReference", (Object)this.parentReference()).add("ChildReference", (Object)this.childReference()).add("LinkName", (Object)this.linkName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ParentReference": {
                return Optional.ofNullable(clazz.cast(this.parentReference()));
            }
            case "ChildReference": {
                return Optional.ofNullable(clazz.cast(this.childReference()));
            }
            case "LinkName": {
                return Optional.ofNullable(clazz.cast(this.linkName()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BatchAttachObjectMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private ObjectReference parentReference;
        private ObjectReference childReference;
        private String linkName;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchAttachObject model) {
            this.parentReference(model.parentReference);
            this.childReference(model.childReference);
            this.linkName(model.linkName);
        }

        public final ObjectReference.Builder getParentReference() {
            return this.parentReference != null ? this.parentReference.toBuilder() : null;
        }

        @Override
        public final Builder parentReference(ObjectReference parentReference) {
            this.parentReference = parentReference;
            return this;
        }

        public final void setParentReference(ObjectReference.BuilderImpl parentReference) {
            this.parentReference = parentReference != null ? parentReference.build() : null;
        }

        public final ObjectReference.Builder getChildReference() {
            return this.childReference != null ? this.childReference.toBuilder() : null;
        }

        @Override
        public final Builder childReference(ObjectReference childReference) {
            this.childReference = childReference;
            return this;
        }

        public final void setChildReference(ObjectReference.BuilderImpl childReference) {
            this.childReference = childReference != null ? childReference.build() : null;
        }

        public final String getLinkName() {
            return this.linkName;
        }

        @Override
        public final Builder linkName(String linkName) {
            this.linkName = linkName;
            return this;
        }

        public final void setLinkName(String linkName) {
            this.linkName = linkName;
        }

        public BatchAttachObject build() {
            return new BatchAttachObject(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BatchAttachObject> {
        public Builder parentReference(ObjectReference var1);

        default public Builder parentReference(Consumer<ObjectReference.Builder> parentReference) {
            return this.parentReference((ObjectReference)((ObjectReference.Builder)ObjectReference.builder().applyMutation(parentReference)).build());
        }

        public Builder childReference(ObjectReference var1);

        default public Builder childReference(Consumer<ObjectReference.Builder> childReference) {
            return this.childReference((ObjectReference)((ObjectReference.Builder)ObjectReference.builder().applyMutation(childReference)).build());
        }

        public Builder linkName(String var1);
    }
}

