/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.clouddirectory.model.UpdateObjectAttributesRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class UpdateObjectAttributesRequestModelMarshaller {
    private static final MarshallingInfo<String> DIRECTORYARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.HEADER).marshallLocationName("x-amz-data-partition").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> OBJECTREFERENCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ObjectReference").isBinary(false).build();
    private static final MarshallingInfo<List> ATTRIBUTEUPDATES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AttributeUpdates").isBinary(false).build();
    private static final UpdateObjectAttributesRequestModelMarshaller INSTANCE = new UpdateObjectAttributesRequestModelMarshaller();

    private UpdateObjectAttributesRequestModelMarshaller() {
    }

    public static UpdateObjectAttributesRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(UpdateObjectAttributesRequest updateObjectAttributesRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)updateObjectAttributesRequest), (String)"updateObjectAttributesRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)updateObjectAttributesRequest.directoryArn(), DIRECTORYARN_BINDING);
            protocolMarshaller.marshall((Object)updateObjectAttributesRequest.objectReference(), OBJECTREFERENCE_BINDING);
            protocolMarshaller.marshall(updateObjectAttributesRequest.attributeUpdates(), ATTRIBUTEUPDATES_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

