/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.clouddirectory.model.PathToObjectIdentifiers;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class PathToObjectIdentifiersMarshaller {
    private static final MarshallingInfo<String> PATH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Path").isBinary(false).build();
    private static final MarshallingInfo<List> OBJECTIDENTIFIERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ObjectIdentifiers").isBinary(false).build();
    private static final PathToObjectIdentifiersMarshaller INSTANCE = new PathToObjectIdentifiersMarshaller();

    private PathToObjectIdentifiersMarshaller() {
    }

    public static PathToObjectIdentifiersMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(PathToObjectIdentifiers pathToObjectIdentifiers, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)pathToObjectIdentifiers, (String)"pathToObjectIdentifiers");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)pathToObjectIdentifiers.path(), PATH_BINDING);
            protocolMarshaller.marshall(pathToObjectIdentifiers.objectIdentifiers(), OBJECTIDENTIFIERS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

