/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.clouddirectory.model.BatchListIndexResponse;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class BatchListIndexResponseMarshaller {
    private static final MarshallingInfo<List> INDEXATTACHMENTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IndexAttachments").isBinary(false).build();
    private static final MarshallingInfo<String> NEXTTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NextToken").isBinary(false).build();
    private static final BatchListIndexResponseMarshaller INSTANCE = new BatchListIndexResponseMarshaller();

    private BatchListIndexResponseMarshaller() {
    }

    public static BatchListIndexResponseMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(BatchListIndexResponse batchListIndexResponse, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)batchListIndexResponse, (String)"batchListIndexResponse");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(batchListIndexResponse.indexAttachments(), INDEXATTACHMENTS_BINDING);
            protocolMarshaller.marshall((Object)batchListIndexResponse.nextToken(), NEXTTOKEN_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

