/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.clouddirectory.model.AttachTypedLinkRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class AttachTypedLinkRequestModelMarshaller {
    private static final MarshallingInfo<String> DIRECTORYARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.HEADER).marshallLocationName("x-amz-data-partition").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> SOURCEOBJECTREFERENCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SourceObjectReference").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> TARGETOBJECTREFERENCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TargetObjectReference").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> TYPEDLINKFACET_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TypedLinkFacet").isBinary(false).build();
    private static final MarshallingInfo<List> ATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Attributes").isBinary(false).build();
    private static final AttachTypedLinkRequestModelMarshaller INSTANCE = new AttachTypedLinkRequestModelMarshaller();

    private AttachTypedLinkRequestModelMarshaller() {
    }

    public static AttachTypedLinkRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(AttachTypedLinkRequest attachTypedLinkRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)attachTypedLinkRequest), (String)"attachTypedLinkRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)attachTypedLinkRequest.directoryArn(), DIRECTORYARN_BINDING);
            protocolMarshaller.marshall((Object)attachTypedLinkRequest.sourceObjectReference(), SOURCEOBJECTREFERENCE_BINDING);
            protocolMarshaller.marshall((Object)attachTypedLinkRequest.targetObjectReference(), TARGETOBJECTREFERENCE_BINDING);
            protocolMarshaller.marshall((Object)attachTypedLinkRequest.typedLinkFacet(), TYPEDLINKFACET_BINDING);
            protocolMarshaller.marshall(attachTypedLinkRequest.attributes(), ATTRIBUTES_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

