/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.clouddirectory.model.AddFacetToObjectRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class AddFacetToObjectRequestModelMarshaller {
    private static final MarshallingInfo<String> DIRECTORYARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.HEADER).marshallLocationName("x-amz-data-partition").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> SCHEMAFACET_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SchemaFacet").isBinary(false).build();
    private static final MarshallingInfo<List> OBJECTATTRIBUTELIST_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ObjectAttributeList").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> OBJECTREFERENCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ObjectReference").isBinary(false).build();
    private static final AddFacetToObjectRequestModelMarshaller INSTANCE = new AddFacetToObjectRequestModelMarshaller();

    private AddFacetToObjectRequestModelMarshaller() {
    }

    public static AddFacetToObjectRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(AddFacetToObjectRequest addFacetToObjectRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)addFacetToObjectRequest), (String)"addFacetToObjectRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)addFacetToObjectRequest.directoryArn(), DIRECTORYARN_BINDING);
            protocolMarshaller.marshall((Object)addFacetToObjectRequest.schemaFacet(), SCHEMAFACET_BINDING);
            protocolMarshaller.marshall(addFacetToObjectRequest.objectAttributeList(), OBJECTATTRIBUTELIST_BINDING);
            protocolMarshaller.marshall((Object)addFacetToObjectRequest.objectReference(), OBJECTREFERENCE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

