/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.clouddirectory.CloudDirectoryAsyncClient;
import software.amazon.awssdk.services.clouddirectory.model.ListObjectPoliciesRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListObjectPoliciesResponse;

public class ListObjectPoliciesPublisher
implements SdkPublisher<ListObjectPoliciesResponse> {
    private final CloudDirectoryAsyncClient client;
    private final ListObjectPoliciesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListObjectPoliciesPublisher(CloudDirectoryAsyncClient client, ListObjectPoliciesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListObjectPoliciesPublisher(CloudDirectoryAsyncClient client, ListObjectPoliciesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListObjectPoliciesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListObjectPoliciesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private final ListObjectPoliciesPublisher resume(ListObjectPoliciesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListObjectPoliciesPublisher(this.client, (ListObjectPoliciesRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListObjectPoliciesPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListObjectPoliciesResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListObjectPoliciesResponseFetcher
    implements AsyncPageFetcher<ListObjectPoliciesResponse> {
        private ListObjectPoliciesResponseFetcher() {
        }

        public boolean hasNextPage(ListObjectPoliciesResponse previousPage) {
            return previousPage.nextToken() != null && !SdkAutoConstructList.class.isInstance(previousPage.nextToken()) && !SdkAutoConstructMap.class.isInstance(previousPage.nextToken());
        }

        public CompletableFuture<ListObjectPoliciesResponse> nextPage(ListObjectPoliciesResponse previousPage) {
            if (previousPage == null) {
                return ListObjectPoliciesPublisher.this.client.listObjectPolicies(ListObjectPoliciesPublisher.this.firstRequest);
            }
            return ListObjectPoliciesPublisher.this.client.listObjectPolicies((ListObjectPoliciesRequest)((Object)ListObjectPoliciesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

