/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.clouddirectory.CloudDirectoryClient;
import software.amazon.awssdk.services.clouddirectory.model.ListFacetAttributesRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListFacetAttributesResponse;

public class ListFacetAttributesIterable
implements SdkIterable<ListFacetAttributesResponse> {
    private final CloudDirectoryClient client;
    private final ListFacetAttributesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListFacetAttributesIterable(CloudDirectoryClient client, ListFacetAttributesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListFacetAttributesResponseFetcher();
    }

    public Iterator<ListFacetAttributesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private final ListFacetAttributesIterable resume(ListFacetAttributesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListFacetAttributesIterable(this.client, (ListFacetAttributesRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListFacetAttributesIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListFacetAttributesResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListFacetAttributesResponseFetcher
    implements SyncPageFetcher<ListFacetAttributesResponse> {
        private ListFacetAttributesResponseFetcher() {
        }

        public boolean hasNextPage(ListFacetAttributesResponse previousPage) {
            return previousPage.nextToken() != null && !SdkAutoConstructList.class.isInstance(previousPage.nextToken()) && !SdkAutoConstructMap.class.isInstance(previousPage.nextToken());
        }

        public ListFacetAttributesResponse nextPage(ListFacetAttributesResponse previousPage) {
            if (previousPage == null) {
                return ListFacetAttributesIterable.this.client.listFacetAttributes(ListFacetAttributesIterable.this.firstRequest);
            }
            return ListFacetAttributesIterable.this.client.listFacetAttributes((ListFacetAttributesRequest)((Object)ListFacetAttributesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

