/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.clouddirectory.model.CloudDirectoryRequest;
import software.amazon.awssdk.services.clouddirectory.model.ObjectReference;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LookupPolicyRequest
extends CloudDirectoryRequest
implements ToCopyableBuilder<Builder, LookupPolicyRequest> {
    private final String directoryArn;
    private final ObjectReference objectReference;
    private final String nextToken;
    private final Integer maxResults;

    private LookupPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.directoryArn = builder.directoryArn;
        this.objectReference = builder.objectReference;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public String directoryArn() {
        return this.directoryArn;
    }

    public ObjectReference objectReference() {
        return this.objectReference;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.objectReference());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LookupPolicyRequest)) {
            return false;
        }
        LookupPolicyRequest other = (LookupPolicyRequest)((Object)obj);
        return Objects.equals(this.directoryArn(), other.directoryArn()) && Objects.equals(this.objectReference(), other.objectReference()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public String toString() {
        return ToString.builder((String)"LookupPolicyRequest").add("DirectoryArn", (Object)this.directoryArn()).add("ObjectReference", (Object)this.objectReference()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DirectoryArn": {
                return Optional.ofNullable(clazz.cast(this.directoryArn()));
            }
            case "ObjectReference": {
                return Optional.ofNullable(clazz.cast(this.objectReference()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudDirectoryRequest.BuilderImpl
    implements Builder {
        private String directoryArn;
        private ObjectReference objectReference;
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(LookupPolicyRequest model) {
            super(model);
            this.directoryArn(model.directoryArn);
            this.objectReference(model.objectReference);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final String getDirectoryArn() {
            return this.directoryArn;
        }

        @Override
        public final Builder directoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
            return this;
        }

        public final void setDirectoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
        }

        public final ObjectReference.Builder getObjectReference() {
            return this.objectReference != null ? this.objectReference.toBuilder() : null;
        }

        @Override
        public final Builder objectReference(ObjectReference objectReference) {
            this.objectReference = objectReference;
            return this;
        }

        public final void setObjectReference(ObjectReference.BuilderImpl objectReference) {
            this.objectReference = objectReference != null ? objectReference.build() : null;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public LookupPolicyRequest build() {
            return new LookupPolicyRequest(this);
        }
    }

    public static interface Builder
    extends CloudDirectoryRequest.Builder,
    CopyableBuilder<Builder, LookupPolicyRequest> {
        public Builder directoryArn(String var1);

        public Builder objectReference(ObjectReference var1);

        default public Builder objectReference(Consumer<ObjectReference.Builder> objectReference) {
            return this.objectReference((ObjectReference)((ObjectReference.Builder)ObjectReference.builder().applyMutation(objectReference)).build());
        }

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

