/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.clouddirectory.model.CloudDirectoryResponse;
import software.amazon.awssdk.services.clouddirectory.model.TypedLinkAttributeDefinition;
import software.amazon.awssdk.services.clouddirectory.model.TypedLinkAttributeDefinitionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTypedLinkFacetAttributesResponse
extends CloudDirectoryResponse
implements ToCopyableBuilder<Builder, ListTypedLinkFacetAttributesResponse> {
    private final List<TypedLinkAttributeDefinition> attributes;
    private final String nextToken;

    private ListTypedLinkFacetAttributesResponse(BuilderImpl builder) {
        super(builder);
        this.attributes = builder.attributes;
        this.nextToken = builder.nextToken;
    }

    public List<TypedLinkAttributeDefinition> attributes() {
        return this.attributes;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTypedLinkFacetAttributesResponse)) {
            return false;
        }
        ListTypedLinkFacetAttributesResponse other = (ListTypedLinkFacetAttributesResponse)((Object)obj);
        return Objects.equals(this.attributes(), other.attributes()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListTypedLinkFacetAttributesResponse").add("Attributes", this.attributes()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Attributes": {
                return Optional.ofNullable(clazz.cast(this.attributes()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudDirectoryResponse.BuilderImpl
    implements Builder {
        private List<TypedLinkAttributeDefinition> attributes = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTypedLinkFacetAttributesResponse model) {
            super(model);
            this.attributes(model.attributes);
            this.nextToken(model.nextToken);
        }

        public final Collection<TypedLinkAttributeDefinition.Builder> getAttributes() {
            return this.attributes != null ? (Collection)this.attributes.stream().map(TypedLinkAttributeDefinition::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder attributes(Collection<TypedLinkAttributeDefinition> attributes) {
            this.attributes = TypedLinkAttributeDefinitionListCopier.copy(attributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(TypedLinkAttributeDefinition ... attributes) {
            this.attributes(Arrays.asList(attributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(Consumer<TypedLinkAttributeDefinition.Builder> ... attributes) {
            this.attributes(Stream.of(attributes).map(c -> (TypedLinkAttributeDefinition)((TypedLinkAttributeDefinition.Builder)TypedLinkAttributeDefinition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAttributes(Collection<TypedLinkAttributeDefinition.BuilderImpl> attributes) {
            this.attributes = TypedLinkAttributeDefinitionListCopier.copyFromBuilder(attributes);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListTypedLinkFacetAttributesResponse build() {
            return new ListTypedLinkFacetAttributesResponse(this);
        }
    }

    public static interface Builder
    extends CloudDirectoryResponse.Builder,
    CopyableBuilder<Builder, ListTypedLinkFacetAttributesResponse> {
        public Builder attributes(Collection<TypedLinkAttributeDefinition> var1);

        public Builder attributes(TypedLinkAttributeDefinition ... var1);

        public Builder attributes(Consumer<TypedLinkAttributeDefinition.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

