/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.clouddirectory.model.CloudDirectoryResponse;
import software.amazon.awssdk.services.clouddirectory.model.PathToObjectIdentifiers;
import software.amazon.awssdk.services.clouddirectory.model.PathToObjectIdentifiersListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListObjectParentPathsResponse
extends CloudDirectoryResponse
implements ToCopyableBuilder<Builder, ListObjectParentPathsResponse> {
    private final List<PathToObjectIdentifiers> pathToObjectIdentifiersList;
    private final String nextToken;

    private ListObjectParentPathsResponse(BuilderImpl builder) {
        super(builder);
        this.pathToObjectIdentifiersList = builder.pathToObjectIdentifiersList;
        this.nextToken = builder.nextToken;
    }

    public List<PathToObjectIdentifiers> pathToObjectIdentifiersList() {
        return this.pathToObjectIdentifiersList;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.pathToObjectIdentifiersList());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListObjectParentPathsResponse)) {
            return false;
        }
        ListObjectParentPathsResponse other = (ListObjectParentPathsResponse)((Object)obj);
        return Objects.equals(this.pathToObjectIdentifiersList(), other.pathToObjectIdentifiersList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListObjectParentPathsResponse").add("PathToObjectIdentifiersList", this.pathToObjectIdentifiersList()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PathToObjectIdentifiersList": {
                return Optional.ofNullable(clazz.cast(this.pathToObjectIdentifiersList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudDirectoryResponse.BuilderImpl
    implements Builder {
        private List<PathToObjectIdentifiers> pathToObjectIdentifiersList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListObjectParentPathsResponse model) {
            super(model);
            this.pathToObjectIdentifiersList(model.pathToObjectIdentifiersList);
            this.nextToken(model.nextToken);
        }

        public final Collection<PathToObjectIdentifiers.Builder> getPathToObjectIdentifiersList() {
            return this.pathToObjectIdentifiersList != null ? (Collection)this.pathToObjectIdentifiersList.stream().map(PathToObjectIdentifiers::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder pathToObjectIdentifiersList(Collection<PathToObjectIdentifiers> pathToObjectIdentifiersList) {
            this.pathToObjectIdentifiersList = PathToObjectIdentifiersListCopier.copy(pathToObjectIdentifiersList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pathToObjectIdentifiersList(PathToObjectIdentifiers ... pathToObjectIdentifiersList) {
            this.pathToObjectIdentifiersList(Arrays.asList(pathToObjectIdentifiersList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pathToObjectIdentifiersList(Consumer<PathToObjectIdentifiers.Builder> ... pathToObjectIdentifiersList) {
            this.pathToObjectIdentifiersList(Stream.of(pathToObjectIdentifiersList).map(c -> (PathToObjectIdentifiers)((PathToObjectIdentifiers.Builder)PathToObjectIdentifiers.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPathToObjectIdentifiersList(Collection<PathToObjectIdentifiers.BuilderImpl> pathToObjectIdentifiersList) {
            this.pathToObjectIdentifiersList = PathToObjectIdentifiersListCopier.copyFromBuilder(pathToObjectIdentifiersList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListObjectParentPathsResponse build() {
            return new ListObjectParentPathsResponse(this);
        }
    }

    public static interface Builder
    extends CloudDirectoryResponse.Builder,
    CopyableBuilder<Builder, ListObjectParentPathsResponse> {
        public Builder pathToObjectIdentifiersList(Collection<PathToObjectIdentifiers> var1);

        public Builder pathToObjectIdentifiersList(PathToObjectIdentifiers ... var1);

        public Builder pathToObjectIdentifiersList(Consumer<PathToObjectIdentifiers.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

