/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.clouddirectory.model.CloudDirectoryResponse;
import software.amazon.awssdk.services.clouddirectory.model.TypedLinkSpecifier;
import software.amazon.awssdk.services.clouddirectory.model.TypedLinkSpecifierListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListIncomingTypedLinksResponse
extends CloudDirectoryResponse
implements ToCopyableBuilder<Builder, ListIncomingTypedLinksResponse> {
    private final List<TypedLinkSpecifier> linkSpecifiers;
    private final String nextToken;

    private ListIncomingTypedLinksResponse(BuilderImpl builder) {
        super(builder);
        this.linkSpecifiers = builder.linkSpecifiers;
        this.nextToken = builder.nextToken;
    }

    public List<TypedLinkSpecifier> linkSpecifiers() {
        return this.linkSpecifiers;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.linkSpecifiers());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIncomingTypedLinksResponse)) {
            return false;
        }
        ListIncomingTypedLinksResponse other = (ListIncomingTypedLinksResponse)((Object)obj);
        return Objects.equals(this.linkSpecifiers(), other.linkSpecifiers()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListIncomingTypedLinksResponse").add("LinkSpecifiers", this.linkSpecifiers()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LinkSpecifiers": {
                return Optional.ofNullable(clazz.cast(this.linkSpecifiers()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudDirectoryResponse.BuilderImpl
    implements Builder {
        private List<TypedLinkSpecifier> linkSpecifiers = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListIncomingTypedLinksResponse model) {
            super(model);
            this.linkSpecifiers(model.linkSpecifiers);
            this.nextToken(model.nextToken);
        }

        public final Collection<TypedLinkSpecifier.Builder> getLinkSpecifiers() {
            return this.linkSpecifiers != null ? (Collection)this.linkSpecifiers.stream().map(TypedLinkSpecifier::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder linkSpecifiers(Collection<TypedLinkSpecifier> linkSpecifiers) {
            this.linkSpecifiers = TypedLinkSpecifierListCopier.copy(linkSpecifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder linkSpecifiers(TypedLinkSpecifier ... linkSpecifiers) {
            this.linkSpecifiers(Arrays.asList(linkSpecifiers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder linkSpecifiers(Consumer<TypedLinkSpecifier.Builder> ... linkSpecifiers) {
            this.linkSpecifiers(Stream.of(linkSpecifiers).map(c -> (TypedLinkSpecifier)((TypedLinkSpecifier.Builder)TypedLinkSpecifier.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLinkSpecifiers(Collection<TypedLinkSpecifier.BuilderImpl> linkSpecifiers) {
            this.linkSpecifiers = TypedLinkSpecifierListCopier.copyFromBuilder(linkSpecifiers);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListIncomingTypedLinksResponse build() {
            return new ListIncomingTypedLinksResponse(this);
        }
    }

    public static interface Builder
    extends CloudDirectoryResponse.Builder,
    CopyableBuilder<Builder, ListIncomingTypedLinksResponse> {
        public Builder linkSpecifiers(Collection<TypedLinkSpecifier> var1);

        public Builder linkSpecifiers(TypedLinkSpecifier ... var1);

        public Builder linkSpecifiers(Consumer<TypedLinkSpecifier.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

