/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.clouddirectory.model.BatchGetObjectInformationResponse;
import software.amazon.awssdk.services.clouddirectory.model.BatchListAttachedIndicesResponse;
import software.amazon.awssdk.services.clouddirectory.model.BatchListIncomingTypedLinksResponse;
import software.amazon.awssdk.services.clouddirectory.model.BatchListIndexResponse;
import software.amazon.awssdk.services.clouddirectory.model.BatchListObjectAttributesResponse;
import software.amazon.awssdk.services.clouddirectory.model.BatchListObjectChildrenResponse;
import software.amazon.awssdk.services.clouddirectory.model.BatchListObjectParentPathsResponse;
import software.amazon.awssdk.services.clouddirectory.model.BatchListObjectPoliciesResponse;
import software.amazon.awssdk.services.clouddirectory.model.BatchListOutgoingTypedLinksResponse;
import software.amazon.awssdk.services.clouddirectory.model.BatchListPolicyAttachmentsResponse;
import software.amazon.awssdk.services.clouddirectory.model.BatchLookupPolicyResponse;
import software.amazon.awssdk.services.clouddirectory.transform.BatchReadSuccessfulResponseMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchReadSuccessfulResponse
implements StructuredPojo,
ToCopyableBuilder<Builder, BatchReadSuccessfulResponse> {
    private final BatchListObjectAttributesResponse listObjectAttributes;
    private final BatchListObjectChildrenResponse listObjectChildren;
    private final BatchGetObjectInformationResponse getObjectInformation;
    private final BatchListAttachedIndicesResponse listAttachedIndices;
    private final BatchListObjectParentPathsResponse listObjectParentPaths;
    private final BatchListObjectPoliciesResponse listObjectPolicies;
    private final BatchListPolicyAttachmentsResponse listPolicyAttachments;
    private final BatchLookupPolicyResponse lookupPolicy;
    private final BatchListIndexResponse listIndex;
    private final BatchListOutgoingTypedLinksResponse listOutgoingTypedLinks;
    private final BatchListIncomingTypedLinksResponse listIncomingTypedLinks;

    private BatchReadSuccessfulResponse(BuilderImpl builder) {
        this.listObjectAttributes = builder.listObjectAttributes;
        this.listObjectChildren = builder.listObjectChildren;
        this.getObjectInformation = builder.getObjectInformation;
        this.listAttachedIndices = builder.listAttachedIndices;
        this.listObjectParentPaths = builder.listObjectParentPaths;
        this.listObjectPolicies = builder.listObjectPolicies;
        this.listPolicyAttachments = builder.listPolicyAttachments;
        this.lookupPolicy = builder.lookupPolicy;
        this.listIndex = builder.listIndex;
        this.listOutgoingTypedLinks = builder.listOutgoingTypedLinks;
        this.listIncomingTypedLinks = builder.listIncomingTypedLinks;
    }

    public BatchListObjectAttributesResponse listObjectAttributes() {
        return this.listObjectAttributes;
    }

    public BatchListObjectChildrenResponse listObjectChildren() {
        return this.listObjectChildren;
    }

    public BatchGetObjectInformationResponse getObjectInformation() {
        return this.getObjectInformation;
    }

    public BatchListAttachedIndicesResponse listAttachedIndices() {
        return this.listAttachedIndices;
    }

    public BatchListObjectParentPathsResponse listObjectParentPaths() {
        return this.listObjectParentPaths;
    }

    public BatchListObjectPoliciesResponse listObjectPolicies() {
        return this.listObjectPolicies;
    }

    public BatchListPolicyAttachmentsResponse listPolicyAttachments() {
        return this.listPolicyAttachments;
    }

    public BatchLookupPolicyResponse lookupPolicy() {
        return this.lookupPolicy;
    }

    public BatchListIndexResponse listIndex() {
        return this.listIndex;
    }

    public BatchListOutgoingTypedLinksResponse listOutgoingTypedLinks() {
        return this.listOutgoingTypedLinks;
    }

    public BatchListIncomingTypedLinksResponse listIncomingTypedLinks() {
        return this.listIncomingTypedLinks;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.listObjectAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.listObjectChildren());
        hashCode = 31 * hashCode + Objects.hashCode(this.getObjectInformation());
        hashCode = 31 * hashCode + Objects.hashCode(this.listAttachedIndices());
        hashCode = 31 * hashCode + Objects.hashCode(this.listObjectParentPaths());
        hashCode = 31 * hashCode + Objects.hashCode(this.listObjectPolicies());
        hashCode = 31 * hashCode + Objects.hashCode(this.listPolicyAttachments());
        hashCode = 31 * hashCode + Objects.hashCode(this.lookupPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.listIndex());
        hashCode = 31 * hashCode + Objects.hashCode(this.listOutgoingTypedLinks());
        hashCode = 31 * hashCode + Objects.hashCode(this.listIncomingTypedLinks());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchReadSuccessfulResponse)) {
            return false;
        }
        BatchReadSuccessfulResponse other = (BatchReadSuccessfulResponse)obj;
        return Objects.equals(this.listObjectAttributes(), other.listObjectAttributes()) && Objects.equals(this.listObjectChildren(), other.listObjectChildren()) && Objects.equals(this.getObjectInformation(), other.getObjectInformation()) && Objects.equals(this.listAttachedIndices(), other.listAttachedIndices()) && Objects.equals(this.listObjectParentPaths(), other.listObjectParentPaths()) && Objects.equals(this.listObjectPolicies(), other.listObjectPolicies()) && Objects.equals(this.listPolicyAttachments(), other.listPolicyAttachments()) && Objects.equals(this.lookupPolicy(), other.lookupPolicy()) && Objects.equals(this.listIndex(), other.listIndex()) && Objects.equals(this.listOutgoingTypedLinks(), other.listOutgoingTypedLinks()) && Objects.equals(this.listIncomingTypedLinks(), other.listIncomingTypedLinks());
    }

    public String toString() {
        return ToString.builder((String)"BatchReadSuccessfulResponse").add("ListObjectAttributes", (Object)this.listObjectAttributes()).add("ListObjectChildren", (Object)this.listObjectChildren()).add("GetObjectInformation", (Object)this.getObjectInformation()).add("ListAttachedIndices", (Object)this.listAttachedIndices()).add("ListObjectParentPaths", (Object)this.listObjectParentPaths()).add("ListObjectPolicies", (Object)this.listObjectPolicies()).add("ListPolicyAttachments", (Object)this.listPolicyAttachments()).add("LookupPolicy", (Object)this.lookupPolicy()).add("ListIndex", (Object)this.listIndex()).add("ListOutgoingTypedLinks", (Object)this.listOutgoingTypedLinks()).add("ListIncomingTypedLinks", (Object)this.listIncomingTypedLinks()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ListObjectAttributes": {
                return Optional.ofNullable(clazz.cast(this.listObjectAttributes()));
            }
            case "ListObjectChildren": {
                return Optional.ofNullable(clazz.cast(this.listObjectChildren()));
            }
            case "GetObjectInformation": {
                return Optional.ofNullable(clazz.cast(this.getObjectInformation()));
            }
            case "ListAttachedIndices": {
                return Optional.ofNullable(clazz.cast(this.listAttachedIndices()));
            }
            case "ListObjectParentPaths": {
                return Optional.ofNullable(clazz.cast(this.listObjectParentPaths()));
            }
            case "ListObjectPolicies": {
                return Optional.ofNullable(clazz.cast(this.listObjectPolicies()));
            }
            case "ListPolicyAttachments": {
                return Optional.ofNullable(clazz.cast(this.listPolicyAttachments()));
            }
            case "LookupPolicy": {
                return Optional.ofNullable(clazz.cast(this.lookupPolicy()));
            }
            case "ListIndex": {
                return Optional.ofNullable(clazz.cast(this.listIndex()));
            }
            case "ListOutgoingTypedLinks": {
                return Optional.ofNullable(clazz.cast(this.listOutgoingTypedLinks()));
            }
            case "ListIncomingTypedLinks": {
                return Optional.ofNullable(clazz.cast(this.listIncomingTypedLinks()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BatchReadSuccessfulResponseMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private BatchListObjectAttributesResponse listObjectAttributes;
        private BatchListObjectChildrenResponse listObjectChildren;
        private BatchGetObjectInformationResponse getObjectInformation;
        private BatchListAttachedIndicesResponse listAttachedIndices;
        private BatchListObjectParentPathsResponse listObjectParentPaths;
        private BatchListObjectPoliciesResponse listObjectPolicies;
        private BatchListPolicyAttachmentsResponse listPolicyAttachments;
        private BatchLookupPolicyResponse lookupPolicy;
        private BatchListIndexResponse listIndex;
        private BatchListOutgoingTypedLinksResponse listOutgoingTypedLinks;
        private BatchListIncomingTypedLinksResponse listIncomingTypedLinks;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchReadSuccessfulResponse model) {
            this.listObjectAttributes(model.listObjectAttributes);
            this.listObjectChildren(model.listObjectChildren);
            this.getObjectInformation(model.getObjectInformation);
            this.listAttachedIndices(model.listAttachedIndices);
            this.listObjectParentPaths(model.listObjectParentPaths);
            this.listObjectPolicies(model.listObjectPolicies);
            this.listPolicyAttachments(model.listPolicyAttachments);
            this.lookupPolicy(model.lookupPolicy);
            this.listIndex(model.listIndex);
            this.listOutgoingTypedLinks(model.listOutgoingTypedLinks);
            this.listIncomingTypedLinks(model.listIncomingTypedLinks);
        }

        public final BatchListObjectAttributesResponse.Builder getListObjectAttributes() {
            return this.listObjectAttributes != null ? this.listObjectAttributes.toBuilder() : null;
        }

        @Override
        public final Builder listObjectAttributes(BatchListObjectAttributesResponse listObjectAttributes) {
            this.listObjectAttributes = listObjectAttributes;
            return this;
        }

        public final void setListObjectAttributes(BatchListObjectAttributesResponse.BuilderImpl listObjectAttributes) {
            this.listObjectAttributes = listObjectAttributes != null ? listObjectAttributes.build() : null;
        }

        public final BatchListObjectChildrenResponse.Builder getListObjectChildren() {
            return this.listObjectChildren != null ? this.listObjectChildren.toBuilder() : null;
        }

        @Override
        public final Builder listObjectChildren(BatchListObjectChildrenResponse listObjectChildren) {
            this.listObjectChildren = listObjectChildren;
            return this;
        }

        public final void setListObjectChildren(BatchListObjectChildrenResponse.BuilderImpl listObjectChildren) {
            this.listObjectChildren = listObjectChildren != null ? listObjectChildren.build() : null;
        }

        public final BatchGetObjectInformationResponse.Builder getGetObjectInformation() {
            return this.getObjectInformation != null ? this.getObjectInformation.toBuilder() : null;
        }

        @Override
        public final Builder getObjectInformation(BatchGetObjectInformationResponse getObjectInformation) {
            this.getObjectInformation = getObjectInformation;
            return this;
        }

        public final void setGetObjectInformation(BatchGetObjectInformationResponse.BuilderImpl getObjectInformation) {
            this.getObjectInformation = getObjectInformation != null ? getObjectInformation.build() : null;
        }

        public final BatchListAttachedIndicesResponse.Builder getListAttachedIndices() {
            return this.listAttachedIndices != null ? this.listAttachedIndices.toBuilder() : null;
        }

        @Override
        public final Builder listAttachedIndices(BatchListAttachedIndicesResponse listAttachedIndices) {
            this.listAttachedIndices = listAttachedIndices;
            return this;
        }

        public final void setListAttachedIndices(BatchListAttachedIndicesResponse.BuilderImpl listAttachedIndices) {
            this.listAttachedIndices = listAttachedIndices != null ? listAttachedIndices.build() : null;
        }

        public final BatchListObjectParentPathsResponse.Builder getListObjectParentPaths() {
            return this.listObjectParentPaths != null ? this.listObjectParentPaths.toBuilder() : null;
        }

        @Override
        public final Builder listObjectParentPaths(BatchListObjectParentPathsResponse listObjectParentPaths) {
            this.listObjectParentPaths = listObjectParentPaths;
            return this;
        }

        public final void setListObjectParentPaths(BatchListObjectParentPathsResponse.BuilderImpl listObjectParentPaths) {
            this.listObjectParentPaths = listObjectParentPaths != null ? listObjectParentPaths.build() : null;
        }

        public final BatchListObjectPoliciesResponse.Builder getListObjectPolicies() {
            return this.listObjectPolicies != null ? this.listObjectPolicies.toBuilder() : null;
        }

        @Override
        public final Builder listObjectPolicies(BatchListObjectPoliciesResponse listObjectPolicies) {
            this.listObjectPolicies = listObjectPolicies;
            return this;
        }

        public final void setListObjectPolicies(BatchListObjectPoliciesResponse.BuilderImpl listObjectPolicies) {
            this.listObjectPolicies = listObjectPolicies != null ? listObjectPolicies.build() : null;
        }

        public final BatchListPolicyAttachmentsResponse.Builder getListPolicyAttachments() {
            return this.listPolicyAttachments != null ? this.listPolicyAttachments.toBuilder() : null;
        }

        @Override
        public final Builder listPolicyAttachments(BatchListPolicyAttachmentsResponse listPolicyAttachments) {
            this.listPolicyAttachments = listPolicyAttachments;
            return this;
        }

        public final void setListPolicyAttachments(BatchListPolicyAttachmentsResponse.BuilderImpl listPolicyAttachments) {
            this.listPolicyAttachments = listPolicyAttachments != null ? listPolicyAttachments.build() : null;
        }

        public final BatchLookupPolicyResponse.Builder getLookupPolicy() {
            return this.lookupPolicy != null ? this.lookupPolicy.toBuilder() : null;
        }

        @Override
        public final Builder lookupPolicy(BatchLookupPolicyResponse lookupPolicy) {
            this.lookupPolicy = lookupPolicy;
            return this;
        }

        public final void setLookupPolicy(BatchLookupPolicyResponse.BuilderImpl lookupPolicy) {
            this.lookupPolicy = lookupPolicy != null ? lookupPolicy.build() : null;
        }

        public final BatchListIndexResponse.Builder getListIndex() {
            return this.listIndex != null ? this.listIndex.toBuilder() : null;
        }

        @Override
        public final Builder listIndex(BatchListIndexResponse listIndex) {
            this.listIndex = listIndex;
            return this;
        }

        public final void setListIndex(BatchListIndexResponse.BuilderImpl listIndex) {
            this.listIndex = listIndex != null ? listIndex.build() : null;
        }

        public final BatchListOutgoingTypedLinksResponse.Builder getListOutgoingTypedLinks() {
            return this.listOutgoingTypedLinks != null ? this.listOutgoingTypedLinks.toBuilder() : null;
        }

        @Override
        public final Builder listOutgoingTypedLinks(BatchListOutgoingTypedLinksResponse listOutgoingTypedLinks) {
            this.listOutgoingTypedLinks = listOutgoingTypedLinks;
            return this;
        }

        public final void setListOutgoingTypedLinks(BatchListOutgoingTypedLinksResponse.BuilderImpl listOutgoingTypedLinks) {
            this.listOutgoingTypedLinks = listOutgoingTypedLinks != null ? listOutgoingTypedLinks.build() : null;
        }

        public final BatchListIncomingTypedLinksResponse.Builder getListIncomingTypedLinks() {
            return this.listIncomingTypedLinks != null ? this.listIncomingTypedLinks.toBuilder() : null;
        }

        @Override
        public final Builder listIncomingTypedLinks(BatchListIncomingTypedLinksResponse listIncomingTypedLinks) {
            this.listIncomingTypedLinks = listIncomingTypedLinks;
            return this;
        }

        public final void setListIncomingTypedLinks(BatchListIncomingTypedLinksResponse.BuilderImpl listIncomingTypedLinks) {
            this.listIncomingTypedLinks = listIncomingTypedLinks != null ? listIncomingTypedLinks.build() : null;
        }

        public BatchReadSuccessfulResponse build() {
            return new BatchReadSuccessfulResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BatchReadSuccessfulResponse> {
        public Builder listObjectAttributes(BatchListObjectAttributesResponse var1);

        default public Builder listObjectAttributes(Consumer<BatchListObjectAttributesResponse.Builder> listObjectAttributes) {
            return this.listObjectAttributes((BatchListObjectAttributesResponse)((BatchListObjectAttributesResponse.Builder)BatchListObjectAttributesResponse.builder().applyMutation(listObjectAttributes)).build());
        }

        public Builder listObjectChildren(BatchListObjectChildrenResponse var1);

        default public Builder listObjectChildren(Consumer<BatchListObjectChildrenResponse.Builder> listObjectChildren) {
            return this.listObjectChildren((BatchListObjectChildrenResponse)((BatchListObjectChildrenResponse.Builder)BatchListObjectChildrenResponse.builder().applyMutation(listObjectChildren)).build());
        }

        public Builder getObjectInformation(BatchGetObjectInformationResponse var1);

        default public Builder getObjectInformation(Consumer<BatchGetObjectInformationResponse.Builder> getObjectInformation) {
            return this.getObjectInformation((BatchGetObjectInformationResponse)((BatchGetObjectInformationResponse.Builder)BatchGetObjectInformationResponse.builder().applyMutation(getObjectInformation)).build());
        }

        public Builder listAttachedIndices(BatchListAttachedIndicesResponse var1);

        default public Builder listAttachedIndices(Consumer<BatchListAttachedIndicesResponse.Builder> listAttachedIndices) {
            return this.listAttachedIndices((BatchListAttachedIndicesResponse)((BatchListAttachedIndicesResponse.Builder)BatchListAttachedIndicesResponse.builder().applyMutation(listAttachedIndices)).build());
        }

        public Builder listObjectParentPaths(BatchListObjectParentPathsResponse var1);

        default public Builder listObjectParentPaths(Consumer<BatchListObjectParentPathsResponse.Builder> listObjectParentPaths) {
            return this.listObjectParentPaths((BatchListObjectParentPathsResponse)((BatchListObjectParentPathsResponse.Builder)BatchListObjectParentPathsResponse.builder().applyMutation(listObjectParentPaths)).build());
        }

        public Builder listObjectPolicies(BatchListObjectPoliciesResponse var1);

        default public Builder listObjectPolicies(Consumer<BatchListObjectPoliciesResponse.Builder> listObjectPolicies) {
            return this.listObjectPolicies((BatchListObjectPoliciesResponse)((BatchListObjectPoliciesResponse.Builder)BatchListObjectPoliciesResponse.builder().applyMutation(listObjectPolicies)).build());
        }

        public Builder listPolicyAttachments(BatchListPolicyAttachmentsResponse var1);

        default public Builder listPolicyAttachments(Consumer<BatchListPolicyAttachmentsResponse.Builder> listPolicyAttachments) {
            return this.listPolicyAttachments((BatchListPolicyAttachmentsResponse)((BatchListPolicyAttachmentsResponse.Builder)BatchListPolicyAttachmentsResponse.builder().applyMutation(listPolicyAttachments)).build());
        }

        public Builder lookupPolicy(BatchLookupPolicyResponse var1);

        default public Builder lookupPolicy(Consumer<BatchLookupPolicyResponse.Builder> lookupPolicy) {
            return this.lookupPolicy((BatchLookupPolicyResponse)((BatchLookupPolicyResponse.Builder)BatchLookupPolicyResponse.builder().applyMutation(lookupPolicy)).build());
        }

        public Builder listIndex(BatchListIndexResponse var1);

        default public Builder listIndex(Consumer<BatchListIndexResponse.Builder> listIndex) {
            return this.listIndex((BatchListIndexResponse)((BatchListIndexResponse.Builder)BatchListIndexResponse.builder().applyMutation(listIndex)).build());
        }

        public Builder listOutgoingTypedLinks(BatchListOutgoingTypedLinksResponse var1);

        default public Builder listOutgoingTypedLinks(Consumer<BatchListOutgoingTypedLinksResponse.Builder> listOutgoingTypedLinks) {
            return this.listOutgoingTypedLinks((BatchListOutgoingTypedLinksResponse)((BatchListOutgoingTypedLinksResponse.Builder)BatchListOutgoingTypedLinksResponse.builder().applyMutation(listOutgoingTypedLinks)).build());
        }

        public Builder listIncomingTypedLinks(BatchListIncomingTypedLinksResponse var1);

        default public Builder listIncomingTypedLinks(Consumer<BatchListIncomingTypedLinksResponse.Builder> listIncomingTypedLinks) {
            return this.listIncomingTypedLinks((BatchListIncomingTypedLinksResponse)((BatchListIncomingTypedLinksResponse.Builder)BatchListIncomingTypedLinksResponse.builder().applyMutation(listIncomingTypedLinks)).build());
        }
    }
}

