/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.clouddirectory.model.BatchReadExceptionType;
import software.amazon.awssdk.services.clouddirectory.transform.BatchReadExceptionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchReadException
implements StructuredPojo,
ToCopyableBuilder<Builder, BatchReadException> {
    private final String type;
    private final String message;

    private BatchReadException(BuilderImpl builder) {
        this.type = builder.type;
        this.message = builder.message;
    }

    public BatchReadExceptionType type() {
        return BatchReadExceptionType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public String message() {
        return this.message;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchReadException)) {
            return false;
        }
        BatchReadException other = (BatchReadException)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.message(), other.message());
    }

    public String toString() {
        return ToString.builder((String)"BatchReadException").add("Type", (Object)this.typeAsString()).add("Message", (Object)this.message()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "Message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BatchReadExceptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchReadException model) {
            this.type(model.type);
            this.message(model.message);
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(BatchReadExceptionType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getMessage() {
            return this.message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public BatchReadException build() {
            return new BatchReadException(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BatchReadException> {
        public Builder type(String var1);

        public Builder type(BatchReadExceptionType var1);

        public Builder message(String var1);
    }
}

