/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.clouddirectory.model.AttributeNameAndValue;
import software.amazon.awssdk.services.clouddirectory.model.AttributeNameAndValueListCopier;
import software.amazon.awssdk.services.clouddirectory.model.CloudDirectoryRequest;
import software.amazon.awssdk.services.clouddirectory.model.ObjectReference;
import software.amazon.awssdk.services.clouddirectory.model.TypedLinkSchemaAndFacetName;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AttachTypedLinkRequest
extends CloudDirectoryRequest
implements ToCopyableBuilder<Builder, AttachTypedLinkRequest> {
    private final String directoryArn;
    private final ObjectReference sourceObjectReference;
    private final ObjectReference targetObjectReference;
    private final TypedLinkSchemaAndFacetName typedLinkFacet;
    private final List<AttributeNameAndValue> attributes;

    private AttachTypedLinkRequest(BuilderImpl builder) {
        super(builder);
        this.directoryArn = builder.directoryArn;
        this.sourceObjectReference = builder.sourceObjectReference;
        this.targetObjectReference = builder.targetObjectReference;
        this.typedLinkFacet = builder.typedLinkFacet;
        this.attributes = builder.attributes;
    }

    public String directoryArn() {
        return this.directoryArn;
    }

    public ObjectReference sourceObjectReference() {
        return this.sourceObjectReference;
    }

    public ObjectReference targetObjectReference() {
        return this.targetObjectReference;
    }

    public TypedLinkSchemaAndFacetName typedLinkFacet() {
        return this.typedLinkFacet;
    }

    public List<AttributeNameAndValue> attributes() {
        return this.attributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceObjectReference());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetObjectReference());
        hashCode = 31 * hashCode + Objects.hashCode(this.typedLinkFacet());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttachTypedLinkRequest)) {
            return false;
        }
        AttachTypedLinkRequest other = (AttachTypedLinkRequest)((Object)obj);
        return Objects.equals(this.directoryArn(), other.directoryArn()) && Objects.equals(this.sourceObjectReference(), other.sourceObjectReference()) && Objects.equals(this.targetObjectReference(), other.targetObjectReference()) && Objects.equals(this.typedLinkFacet(), other.typedLinkFacet()) && Objects.equals(this.attributes(), other.attributes());
    }

    public String toString() {
        return ToString.builder((String)"AttachTypedLinkRequest").add("DirectoryArn", (Object)this.directoryArn()).add("SourceObjectReference", (Object)this.sourceObjectReference()).add("TargetObjectReference", (Object)this.targetObjectReference()).add("TypedLinkFacet", (Object)this.typedLinkFacet()).add("Attributes", this.attributes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DirectoryArn": {
                return Optional.ofNullable(clazz.cast(this.directoryArn()));
            }
            case "SourceObjectReference": {
                return Optional.ofNullable(clazz.cast(this.sourceObjectReference()));
            }
            case "TargetObjectReference": {
                return Optional.ofNullable(clazz.cast(this.targetObjectReference()));
            }
            case "TypedLinkFacet": {
                return Optional.ofNullable(clazz.cast(this.typedLinkFacet()));
            }
            case "Attributes": {
                return Optional.ofNullable(clazz.cast(this.attributes()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudDirectoryRequest.BuilderImpl
    implements Builder {
        private String directoryArn;
        private ObjectReference sourceObjectReference;
        private ObjectReference targetObjectReference;
        private TypedLinkSchemaAndFacetName typedLinkFacet;
        private List<AttributeNameAndValue> attributes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AttachTypedLinkRequest model) {
            super(model);
            this.directoryArn(model.directoryArn);
            this.sourceObjectReference(model.sourceObjectReference);
            this.targetObjectReference(model.targetObjectReference);
            this.typedLinkFacet(model.typedLinkFacet);
            this.attributes(model.attributes);
        }

        public final String getDirectoryArn() {
            return this.directoryArn;
        }

        @Override
        public final Builder directoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
            return this;
        }

        public final void setDirectoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
        }

        public final ObjectReference.Builder getSourceObjectReference() {
            return this.sourceObjectReference != null ? this.sourceObjectReference.toBuilder() : null;
        }

        @Override
        public final Builder sourceObjectReference(ObjectReference sourceObjectReference) {
            this.sourceObjectReference = sourceObjectReference;
            return this;
        }

        public final void setSourceObjectReference(ObjectReference.BuilderImpl sourceObjectReference) {
            this.sourceObjectReference = sourceObjectReference != null ? sourceObjectReference.build() : null;
        }

        public final ObjectReference.Builder getTargetObjectReference() {
            return this.targetObjectReference != null ? this.targetObjectReference.toBuilder() : null;
        }

        @Override
        public final Builder targetObjectReference(ObjectReference targetObjectReference) {
            this.targetObjectReference = targetObjectReference;
            return this;
        }

        public final void setTargetObjectReference(ObjectReference.BuilderImpl targetObjectReference) {
            this.targetObjectReference = targetObjectReference != null ? targetObjectReference.build() : null;
        }

        public final TypedLinkSchemaAndFacetName.Builder getTypedLinkFacet() {
            return this.typedLinkFacet != null ? this.typedLinkFacet.toBuilder() : null;
        }

        @Override
        public final Builder typedLinkFacet(TypedLinkSchemaAndFacetName typedLinkFacet) {
            this.typedLinkFacet = typedLinkFacet;
            return this;
        }

        public final void setTypedLinkFacet(TypedLinkSchemaAndFacetName.BuilderImpl typedLinkFacet) {
            this.typedLinkFacet = typedLinkFacet != null ? typedLinkFacet.build() : null;
        }

        public final Collection<AttributeNameAndValue.Builder> getAttributes() {
            return this.attributes != null ? (Collection)this.attributes.stream().map(AttributeNameAndValue::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder attributes(Collection<AttributeNameAndValue> attributes) {
            this.attributes = AttributeNameAndValueListCopier.copy(attributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(AttributeNameAndValue ... attributes) {
            this.attributes(Arrays.asList(attributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(Consumer<AttributeNameAndValue.Builder> ... attributes) {
            this.attributes(Stream.of(attributes).map(c -> (AttributeNameAndValue)((AttributeNameAndValue.Builder)AttributeNameAndValue.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAttributes(Collection<AttributeNameAndValue.BuilderImpl> attributes) {
            this.attributes = AttributeNameAndValueListCopier.copyFromBuilder(attributes);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AttachTypedLinkRequest build() {
            return new AttachTypedLinkRequest(this);
        }
    }

    public static interface Builder
    extends CloudDirectoryRequest.Builder,
    CopyableBuilder<Builder, AttachTypedLinkRequest> {
        public Builder directoryArn(String var1);

        public Builder sourceObjectReference(ObjectReference var1);

        default public Builder sourceObjectReference(Consumer<ObjectReference.Builder> sourceObjectReference) {
            return this.sourceObjectReference((ObjectReference)((ObjectReference.Builder)ObjectReference.builder().applyMutation(sourceObjectReference)).build());
        }

        public Builder targetObjectReference(ObjectReference var1);

        default public Builder targetObjectReference(Consumer<ObjectReference.Builder> targetObjectReference) {
            return this.targetObjectReference((ObjectReference)((ObjectReference.Builder)ObjectReference.builder().applyMutation(targetObjectReference)).build());
        }

        public Builder typedLinkFacet(TypedLinkSchemaAndFacetName var1);

        default public Builder typedLinkFacet(Consumer<TypedLinkSchemaAndFacetName.Builder> typedLinkFacet) {
            return this.typedLinkFacet((TypedLinkSchemaAndFacetName)((TypedLinkSchemaAndFacetName.Builder)TypedLinkSchemaAndFacetName.builder().applyMutation(typedLinkFacet)).build());
        }

        public Builder attributes(Collection<AttributeNameAndValue> var1);

        public Builder attributes(AttributeNameAndValue ... var1);

        public Builder attributes(Consumer<AttributeNameAndValue.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

